/*
 * Decompiled with CFR 0.152.
 */
package cbg.ui;

import cbg.boardParts.LawCard;
import cbg.common.UIConsts;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PlayerStatsPanel
extends JPanel
implements PropertyChangeListener,
UIConsts {
    private static final long serialVersionUID = -1774620791714208348L;
    private JLabel nameAgeLabel;
    private JLabel ageLbl;
    private JLabel activeLawsLbl;
    private JLabel cardPlaysLabel;
    private JLabel lobLabel;
    private JLabel bodyLabel;

    public PlayerStatsPanel(String name) {
        this.createGUIComponents(name);
    }

    private void createGUIComponents(String name) {
        this.nameAgeLabel = new JLabel("Player: " + name + ", Age: ");
        this.bodyLabel = new JLabel("No Higher Body");
        this.ageLbl = new JLabel(String.valueOf(0));
        JLabel cplLabel = new JLabel("Card plays left: ");
        this.cardPlaysLabel = new JLabel("2");
        JLabel levelLabel = new JLabel("Level of Being: ");
        this.lobLabel = new JLabel("Multiplicity");
        JLabel activeLawsLabel = new JLabel("Active Laws: ");
        this.activeLawsLbl = new JLabel("");
        JPanel panel0 = new JPanel();
        panel0.add(this.nameAgeLabel);
        panel0.add(this.ageLbl);
        JPanel panel1 = new JPanel();
        panel1.add(this.bodyLabel);
        JPanel panel2 = new JPanel();
        panel2.add(cplLabel);
        panel2.add(this.cardPlaysLabel);
        JPanel panel3 = new JPanel();
        panel3.add(levelLabel);
        panel3.add(this.lobLabel);
        JPanel panel4 = new JPanel();
        panel4.add(activeLawsLabel);
        panel4.add(this.activeLawsLbl);
        this.setLayout(new BoxLayout(this, 1));
        this.add(panel0);
        this.add(panel1);
        this.add(panel2);
        this.add(panel3);
        this.add(panel4);
    }

    public void setPlayerName(String name) {
        this.nameAgeLabel.setText("Player: " + name + ", Age: ");
    }

    public void setAge(int age) {
        this.ageLbl.setText(String.valueOf(age));
    }

    public void updateActiveLawsLabel(ArrayList laws) {
        if (laws.size() > 0) {
            StringBuffer lb = new StringBuffer("<html>" + ((LawCard)laws.get(0)).getCard().toString());
            int i = 1;
            while (i < laws.size()) {
                lb.append(",<br>").append(((LawCard)laws.get(i)).getCard().toString());
                ++i;
            }
            lb.append("</html>");
            this.activeLawsLbl.setText(lb.toString());
        } else {
            this.activeLawsLbl.setText("");
        }
    }

    public void updateLob(String newLob) {
        this.lobLabel.setText(newLob);
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        if (arg0.getPropertyName().equals("CardPlaysLeft")) {
            Object newVal = arg0.getNewValue();
            this.cardPlaysLabel.setText(newVal.toString());
        } else if (arg0.getPropertyName().equals("NewBody")) {
            Object newVal = arg0.getNewValue();
            this.bodyLabel.setText(newVal.toString());
        }
    }
}

