/*
 * Decompiled with CFR 0.152.
 */
package cbg.ui;

import cbg.boardParts.Dice;
import cbg.boardParts.LawCard;
import cbg.common.UIConsts;
import cbg.player.Player;
import cbg.ui.CBGDlgFactory;
import cbg.ui.ConsciousBoardgameGUI;
import cbg.ui.IconFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PickLawsDialog
extends JDialog
implements UIConsts,
ActionListener {
    private LawCard randomLaw;
    private LawCard chosenLaw = null;
    private boolean finished = false;
    public static final String FINISHED = "finished";
    private JPanel lhPanel;
    private JPanel playsPanel;
    private JLabel instruction;
    private JLabel randomLabel;
    private JLabel choiceLabel;
    private JButton randomButton;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public PickLawsDialog(JFrame frame) {
        super((Frame)frame, false);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("CHOOSERANDOM".equals(cmd)) {
            Player player = ConsciousBoardgameGUI.getInstance().getCurrentPlayer();
            int roll1 = Dice.roll();
            if (roll1 == 0) {
                JOptionPane.showMessageDialog(this, "You rolled a 0, no law chosen by random.");
                this.randomLabel.setIcon(null);
                this.randomLabel.setText("None by random.");
            } else if (player.getLawHand().size() == 0) {
                JOptionPane.showMessageDialog(this, "You have no law cards in your hand,\nno law chosen by random.");
                this.randomLabel.setIcon(null);
                this.randomLabel.setText("None by random.");
            } else {
                Random r = new Random(System.currentTimeMillis());
                int pick = r.nextInt(player.getLawHand().size());
                JOptionPane.showMessageDialog(this, "You drew card number " + (pick + 1));
                this.randomLaw = (LawCard)player.getLawHand().get(pick);
                player.getLawHand().remove(pick);
                player.addLawToPlay(this.randomLaw);
                this.randomLabel.setIcon(IconFactory.cardIcons[this.randomLaw.getCard().getRank()][this.randomLaw.getCard().getSuit()]);
                this.randomLabel.setVerticalTextPosition(1);
                this.randomLabel.setText(this.randomLaw.getLawDesc());
                this.randomLabel.setPreferredSize(new Dimension((int)this.randomLabel.getPreferredSize().getWidth() + 20, (int)this.randomLabel.getPreferredSize().getHeight() + 20));
                this.lhPanel.remove(pick);
            }
            if (player.getLawPlaysThis() == 1) {
                this.setFinished(true);
            } else if (player.getLawHand().size() == 0) {
                JOptionPane.showMessageDialog(this, "There are no more law cards\nin your hand, no law by choice.");
                this.setFinished(true);
            } else {
                this.randomButton.setVisible(false);
                this.enableLawButtons();
                this.instruction.setText("<html>Now select a law card by choice.<br>(Click on the desired law)</html>");
            }
        } else if ("LAWCHOICE".equals(cmd)) {
            if (!this.chooseCard(e)) {
                return;
            }
            this.setFinished(true);
        }
        this.validate();
        this.lhPanel.updateUI();
    }

    private boolean chooseCard(ActionEvent e) {
        Player player = ConsciousBoardgameGUI.getInstance().getCurrentPlayer();
        int value = Integer.parseInt(((JButton)e.getSource()).getName());
        int i = 0;
        while (i < player.getLawHand().size()) {
            LawCard lc = (LawCard)player.getLawHand().get(i);
            if (value == lc.getLawValue()) {
                this.chosenLaw = lc;
                break;
            }
            ++i;
        }
        if (this.chosenLaw.getCard().getRank() == 14 && player.hasNonAceLaw()) {
            CBGDlgFactory.displayInformationMessage("Can't Choose Death", "Sorry, you can't choose death if there\nis another option available.");
            return false;
        }
        if (this.chosenLaw.getCard().getRank() == 16 && player.hasNonAceJkrLaw()) {
            CBGDlgFactory.displayInformationMessage("Can't Choose Hasnamuss", "Sorry, you can't choose to be a Hasnamuss\nunless death is your only other choice.");
            return false;
        }
        int n = JOptionPane.showConfirmDialog(this, "You chose law card " + this.chosenLaw.getCard() + "\nAccept this choice?", "Confirm Choice", 0);
        if (n == 0) {
            player.addLawToPlay(this.chosenLaw);
            player.getLawHand().remove(this.chosenLaw);
            return true;
        }
        return false;
    }

    private void enableLawButtons() {
        int i = 0;
        while (i < this.lhPanel.getComponentCount()) {
            this.lhPanel.getComponent(i).setEnabled(true);
            ++i;
        }
    }

    public void displayHandView() {
        this.lhPanel.removeAll();
        Iterator it = ConsciousBoardgameGUI.getInstance().getCurrentPlayer().getLawHand().iterator();
        while (it.hasNext()) {
            LawCard lc = (LawCard)it.next();
            JButton lcBtn = new JButton(IconFactory.cardIcons[lc.getCard().getRank()][lc.getCard().getSuit()]);
            lcBtn.setName(String.valueOf(lc.getLawValue()));
            lcBtn.setHorizontalTextPosition(0);
            lcBtn.setVerticalTextPosition(3);
            lcBtn.setText(lc.getLawDesc());
            lcBtn.setActionCommand("LAWCHOICE");
            lcBtn.addActionListener(this);
            lcBtn.setEnabled(false);
            this.lhPanel.add(lcBtn);
        }
        this.validate();
    }

    public void updateHandView(Collection cards) {
        this.lhPanel.removeAll();
        Iterator it = cards.iterator();
        while (it.hasNext()) {
            LawCard lc = (LawCard)it.next();
            JButton lcBtn = new JButton(IconFactory.cardIcons[lc.getCard().getRank()][lc.getCard().getSuit()]);
            lcBtn.setText(lc.getLawDesc());
            lcBtn.setActionCommand("LAWCHOICE");
            lcBtn.addActionListener(this);
            this.lhPanel.add(lcBtn);
        }
        this.validate();
    }

    public void createAndShowDialog() {
        Container contentPane = this.getContentPane();
        contentPane.add(this.createLawHand(), "Last");
        contentPane.add((Component)this.createButtonPane(false), "First");
        contentPane.add(this.createPlaysPane(), "Center");
    }

    public void createChoiceDialog() {
        Container contentPane = this.getContentPane();
        contentPane.add(this.createLawHand(), "Last");
        contentPane.add((Component)this.createButtonPane(true), "Center");
        this.enableLawButtons();
    }

    private Component createPlaysPane() {
        this.playsPanel = new JPanel(new GridLayout(0, 2));
        Box rPanel = new Box(1);
        Box cPanel = new Box(1);
        JLabel randTxt = new JLabel("By Random:");
        randTxt.setAlignmentX(0.5f);
        rPanel.add(randTxt);
        this.randomLabel = new JLabel(IconFactory.cardIcons[0][0]);
        this.randomLabel.setAlignmentX(0.0f);
        rPanel.add(this.randomLabel);
        if (ConsciousBoardgameGUI.getInstance().getCurrentPlayer().getLawPlaysThis() == 1) {
            cPanel.add(new JLabel(""));
            this.choiceLabel = new JLabel("");
            cPanel.add(this.choiceLabel);
        } else {
            JLabel chosenTxt = new JLabel("By Choice:");
            chosenTxt.setAlignmentX(0.5f);
            cPanel.add(new JLabel("By Choice:"));
            this.choiceLabel = new JLabel(IconFactory.cardIcons[0][0]);
            cPanel.add(this.choiceLabel);
        }
        this.playsPanel.add(rPanel);
        this.playsPanel.add(cPanel);
        this.playsPanel.setBorder(BorderFactory.createEmptyBorder(15, 0, 15, 0));
        return this.playsPanel;
    }

    private Component createLawHand() {
        this.lhPanel = new JPanel(new GridLayout(1, ConsciousBoardgameGUI.getInstance().getCurrentPlayer().getLawHand().size()));
        this.displayHandView();
        JScrollPane scrollPane = new JScrollPane(this.lhPanel, 21, 30);
        scrollPane.setMinimumSize(new Dimension(this.lhPanel.getWidth(), this.lhPanel.getHeight() + 20));
        return scrollPane;
    }

    protected JComponent createButtonPane(boolean choiceOnly) {
        if (choiceOnly) {
            this.instruction = new JLabel("Click on the law card of your choice.");
        } else {
            this.randomButton = new JButton("One by Random");
            this.instruction = new JLabel("Pick one by random (Click the button)");
            this.randomButton.setActionCommand("CHOOSERANDOM");
            this.randomButton.addActionListener(this);
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        buttonPanel.setAlignmentX(0.5f);
        buttonPanel.setAlignmentY(0.5f);
        buttonPanel.add(this.instruction);
        if (!choiceOnly) {
            buttonPanel.add(this.randomButton);
        }
        return buttonPanel;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean newValue) {
        boolean oldValue = this.finished;
        this.finished = newValue;
        this.changes.firePropertyChange(FINISHED, oldValue, newValue);
    }
}

