/*
 * Decompiled with CFR 0.152.
 */
package cbg.ui;

import cbg.boardParts.Card;
import cbg.boardParts.LawCard;
import cbg.common.UIConsts;
import cbg.player.Player;
import cbg.ui.CardHandPanel;
import cbg.ui.ConsciousBoardgameGUI;
import cbg.ui.IconFactory;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class LawsInPlayPanel
extends JPanel
implements UIConsts {
    private JButton obeyBtn;
    private JPanel lawCards;

    public LawsInPlayPanel() {
        Box box = new Box(1);
        box.add(this.createBtnRow());
        box.add(this.createLCPane());
        this.add(box);
    }

    private Component createBtnRow() {
        this.obeyBtn = new JButton("Obey Law");
        this.obeyBtn.setActionCommand("OBEYLAW");
        this.obeyBtn.addActionListener(ConsciousBoardgameGUI.getInstance());
        JLabel hint = new JLabel("Place mouse over the law card to read law");
        JPanel firstRow = new JPanel();
        firstRow.add(hint);
        firstRow.add(this.obeyBtn);
        return firstRow;
    }

    private Component createLCPane() {
        this.lawCards = new JPanel();
        return this.lawCards;
    }

    public void updateView(Player plyr) {
        this.lawCards.removeAll();
        Iterator it = plyr.getLawsInPlay().iterator();
        while (it.hasNext()) {
            LawCard c = (LawCard)it.next();
            JToggleButton button = new JToggleButton(IconFactory.cardIcons[c.getCard().getRank()][c.getCard().getSuit()]);
            button.setToolTipText(c.getLawDesc());
            this.lawCards.add(button);
        }
        this.validate();
    }

    public short[] playSelectedCards(Player plyr, CardHandPanel chPanel) {
        ArrayList selectedCards = chPanel.getSelectedCards(plyr);
        ArrayList selectedLawCards = this.getSelectedLawCards(plyr);
        int nC = selectedCards.size();
        int nLC = selectedLawCards.size();
        short[] shocks = new short[4];
        if (nC + nLC > 3) {
            JOptionPane.showMessageDialog(this, "You can play up to 3 cards at a time.\nYou tried to play " + nC + "cards and " + nLC + " laws.");
            this.deselectAllButtons();
            chPanel.deselectAllButtons();
            return shocks;
        }
        if (nC > plyr.getCardPlays()) {
            JOptionPane.showMessageDialog(this, "You have " + plyr.getCardPlays() + " card plays left this turn.\n" + "You tried to play " + nC);
            this.deselectAllButtons();
            chPanel.deselectAllButtons();
            return shocks;
        }
        if (nC + nLC == 1) {
            LawCard lc = (LawCard)selectedLawCards.remove(0);
            if (!lc.getCard().isFaceCard()) {
                JOptionPane.showMessageDialog(this, "You can only play a face card by itself.");
                this.deselectAllButtons();
                return shocks;
            }
            if (lc.isPlayed()) {
                if (lc.isPlayed()) {
                    JOptionPane.showMessageDialog(this, "Law Card " + lc.getCard() + " has already been played");
                    return shocks;
                }
            } else {
                shocks = plyr.getEp().createPiece(lc.getCard());
                lc.setPlayed(true);
            }
        } else if (nC + nLC == 2) {
            LawCard lc1 = (LawCard)selectedLawCards.remove(0);
            Card c1 = lc1.getCard();
            if (lc1.isPlayed()) {
                JOptionPane.showMessageDialog(this, "Law Card " + c1 + " has already been played");
                return shocks;
            }
            LawCard lc2 = null;
            Card c2 = null;
            if (nLC == 1) {
                c2 = (Card)selectedCards.get(0);
            } else {
                lc2 = (LawCard)selectedLawCards.remove(0);
                c2 = lc2.getCard();
                if (lc2.isPlayed()) {
                    JOptionPane.showMessageDialog(this, "Law Card " + c2 + " has already been played");
                    return shocks;
                }
            }
            Card newCard = Card.playsWith(c1, c2);
            if (newCard == null) {
                JOptionPane.showMessageDialog(this, "These cards do not play together.");
                this.deselectAllButtons();
                return shocks;
            }
            shocks = plyr.getEp().createPiece(newCard);
            lc1.setPlayed(true);
            if (lc2 != null) {
                lc2.setPlayed(true);
            } else {
                plyr.getPocHand().remove(c2);
            }
            plyr.takeCardPlays(nC);
        } else if (nC + nLC == 3) {
            LawCard lc1 = (LawCard)selectedLawCards.remove(0);
            Card c1 = lc1.getCard();
            if (lc1.isPlayed()) {
                JOptionPane.showMessageDialog(this, "Law Card " + c1 + " has already been played");
                return shocks;
            }
            LawCard lc2 = null;
            LawCard lc3 = null;
            Card c2 = null;
            Card c3 = null;
            if (nLC == 1) {
                c2 = (Card)selectedCards.get(0);
                c3 = (Card)selectedCards.get(1);
            } else if (nLC == 2) {
                lc2 = (LawCard)selectedLawCards.remove(0);
                c2 = lc2.getCard();
                c3 = (Card)selectedCards.get(0);
                if (lc2.isPlayed()) {
                    JOptionPane.showMessageDialog(this, "Law Card " + c2 + " has already been played");
                    return shocks;
                }
            } else {
                System.out.println("trip law card play?");
                lc2 = (LawCard)selectedLawCards.remove(0);
                lc3 = (LawCard)selectedLawCards.remove(0);
                c2 = lc2.getCard();
                c3 = lc3.getCard();
                if (lc2.isPlayed()) {
                    JOptionPane.showMessageDialog(this, "Law Card " + c2 + " has already been played");
                    return shocks;
                }
                if (lc3.isPlayed()) {
                    JOptionPane.showMessageDialog(this, "Law Card " + c3 + " has already been played");
                    return shocks;
                }
            }
            System.out.println("Playing trips! " + c1 + ", " + c2 + ", " + c3);
            Card newCard = Card.playTrips(c1, c2, c3);
            if (newCard == null) {
                JOptionPane.showMessageDialog(this, "These cards do not play together.");
                this.deselectAllButtons();
                return shocks;
            }
            shocks = plyr.getEp().createTwoPieces(newCard);
            lc1.setPlayed(true);
            if (lc2 != null) {
                lc2.setPlayed(true);
            } else {
                plyr.getPocHand().remove(c2);
            }
            if (lc3 != null) {
                lc3.setPlayed(true);
            } else {
                plyr.getPocHand().remove(c3);
            }
            plyr.takeCardPlays(nC);
        }
        chPanel.deselectAllButtons();
        this.deselectAllButtons();
        return shocks;
    }

    public ArrayList getSelectedLawCards(Player plyr) {
        ArrayList selCards = new ArrayList();
        int i = 0;
        while (i < this.lawCards.getComponentCount()) {
            JToggleButton btn = (JToggleButton)this.lawCards.getComponent(i);
            if (btn.isSelected()) {
                selCards.add(plyr.getLawsInPlay().get(i));
            }
            ++i;
        }
        return selCards;
    }

    public void deselectAllButtons() {
        int i = 0;
        while (i < this.lawCards.getComponentCount()) {
            JToggleButton btn = (JToggleButton)this.lawCards.getComponent(i);
            btn.setSelected(false);
            ++i;
        }
    }
}

