/*
 * Decompiled with CFR 0.152.
 */
package cbg.ui;

import cbg.common.UIConsts;
import cbg.player.FoodDiagram;
import cbg.ui.IconFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;

public class FoodDiagramPanel
extends JLayeredPane
implements UIConsts,
PropertyChangeListener {
    public static final int Width = 286;
    public static final int Height = 264;
    private JLabel[] noteLabels = new JLabel[18];
    private JLabel[] accumLabels;
    private JLabel accrueMI192;
    private JLabel accrueMI48;
    private JLabel accrueDO48;
    private JLabel accrueTI12;
    private JLabel accrueMI12;
    private JLabel diagramLabel;

    public FoodDiagramPanel() throws HeadlessException {
        int i = 0;
        while (i < this.noteLabels.length) {
            this.noteLabels[i] = new JLabel(IconFactory.noChipIcon);
            ++i;
        }
        this.accumLabels = new JLabel[15];
        i = 0;
        while (i < this.accumLabels.length) {
            this.accumLabels[i] = new JLabel(IconFactory.noChipIcon);
            ++i;
        }
        this.accrueMI192 = new JLabel(IconFactory.noChipIcon);
        this.accrueMI48 = new JLabel(IconFactory.noChipIcon);
        this.accrueDO48 = new JLabel(IconFactory.noChipIcon);
        this.accrueTI12 = new JLabel(IconFactory.noChipIcon);
        this.accrueMI12 = new JLabel(IconFactory.noChipIcon);
        Dimension size = new Dimension(286, 264);
        this.diagramLabel = new JLabel(IconFactory.diagramIcon);
        this.diagramLabel.setBounds(0, 0, size.width, size.height);
        this.diagramLabel.setBackground(Color.black);
        this.add((Component)this.diagramLabel, JLayeredPane.DEFAULT_LAYER);
        int i2 = 0;
        while (i2 < this.noteLabels.length) {
            Point p = this.getNoteScreenPos(i2);
            if (p == null) {
                System.err.println("point is null.");
            }
            this.noteLabels[i2].setBounds(p.x, p.y, 22, 22);
            this.add((Component)this.noteLabels[i2], JLayeredPane.PALETTE_LAYER);
            ++i2;
        }
        this.accrueMI192.setBounds(22, 198, 22, 22);
        this.accrueMI48.setBounds(44, 154, 22, 22);
        this.accrueDO48.setBounds(88, 198, 22, 22);
        this.accrueTI12.setBounds(44, 88, 22, 22);
        this.accrueMI12.setBounds(88, 132, 22, 22);
        this.add((Component)this.accrueMI192, JLayeredPane.PALETTE_LAYER);
        this.add((Component)this.accrueMI48, JLayeredPane.PALETTE_LAYER);
        this.add((Component)this.accrueDO48, JLayeredPane.PALETTE_LAYER);
        this.add((Component)this.accrueTI12, JLayeredPane.PALETTE_LAYER);
        this.add((Component)this.accrueMI12, JLayeredPane.PALETTE_LAYER);
        Point p = this.getNoteScreenPos(7);
        int i3 = 0;
        while (i3 < 5) {
            this.accumLabels[i3].setBounds(p.x + 22 * (i3 + 1), p.y, 22, 22);
            ++i3;
        }
        p = this.getNoteScreenPos(13);
        i3 = 0;
        while (i3 < 6) {
            this.accumLabels[5 + i3].setBounds(p.x + 22 * (i3 + 1), p.y, 22, 22);
            ++i3;
        }
        p = this.getNoteScreenPos(17);
        i3 = 0;
        while (i3 < 4) {
            this.accumLabels[11 + i3].setBounds(p.x, p.y - 22 * (i3 + 1), 22, 22);
            ++i3;
        }
        i3 = 0;
        while (i3 < this.accumLabels.length) {
            this.add((Component)this.accumLabels[i3], JLayeredPane.PALETTE_LAYER);
            ++i3;
        }
        this.setPreferredSize(size);
        this.setMinimumSize(size);
    }

    private void updateState(FoodDiagram fd) {
        fd.updateState();
        byte[] state = fd.getCurrentState();
        int i = 0;
        while (i < state.length) {
            this.noteLabels[i].setIcon(this.getIconForState(state[i]));
            ++i;
        }
        state = new byte[5];
        state = fd.getAccrualStates();
        this.accrueMI192.setIcon(this.getIconForAccrueState(state[0], false));
        this.accrueMI48.setIcon(this.getIconForAccrueState(state[1], true));
        this.accrueDO48.setIcon(this.getIconForAccrueState(state[2], false));
        this.accrueTI12.setIcon(this.getIconForAccrueState(state[3], true));
        this.accrueMI12.setIcon(this.getIconForAccrueState(state[4], false));
        state = new byte[15];
        state = fd.getAccumStates();
        i = 0;
        while (i < state.length) {
            this.accumLabels[i].setIcon(this.getIconForState(state[i]));
            ++i;
        }
    }

    private Icon getIconForAccrueState(byte state, boolean vert) {
        if (vert) {
            switch (state) {
                case 0: {
                    return IconFactory.noChipIcon;
                }
                case 1: {
                    return IconFactory.oneVertAccrueIcon;
                }
                case 2: {
                    return IconFactory.twoVertAccrueIcon;
                }
            }
        } else {
            switch (state) {
                case 0: {
                    return IconFactory.noChipIcon;
                }
                case 1: {
                    return IconFactory.oneAccrueIcon;
                }
                case 2: {
                    return IconFactory.twoAccrueIcon;
                }
            }
        }
        System.err.println("Could not find accumulation icon for\nstate=" + state + "; vertical?" + vert);
        return null;
    }

    private Icon getIconForState(byte b) {
        switch (b) {
            case 0: {
                return IconFactory.noChipIcon;
            }
            case 1: {
                return IconFactory.chipIcon;
            }
            case 2: {
                return IconFactory.astralIcon;
            }
            case 3: {
                return IconFactory.caIcon;
            }
            case 4: {
                return IconFactory.mentalIcon;
            }
            case 5: {
                return IconFactory.cmIcon;
            }
            case 6: {
                return IconFactory.amIcon;
            }
            case 7: {
                return IconFactory.camIcon;
            }
        }
        System.err.println("Could not find icon for state=" + b + " returning null");
        return null;
    }

    private Point getNoteScreenPos(int i) {
        switch (i) {
            case 0: {
                return new Point(0, 242);
            }
            case 1: {
                return new Point(0, 220);
            }
            case 2: {
                return new Point(0, 198);
            }
            case 3: {
                return new Point(0, 154);
            }
            case 4: {
                return new Point(0, 132);
            }
            case 5: {
                return new Point(22, 110);
            }
            case 6: {
                return new Point(44, 110);
            }
            case 7: {
                return new Point(88, 110);
            }
            case 8: {
                return new Point(0, 176);
            }
            case 9: {
                return new Point(22, 176);
            }
            case 10: {
                return new Point(44, 176);
            }
            case 11: {
                return new Point(88, 176);
            }
            case 12: {
                return new Point(110, 176);
            }
            case 13: {
                return new Point(132, 176);
            }
            case 14: {
                return new Point(66, 198);
            }
            case 15: {
                return new Point(66, 154);
            }
            case 16: {
                return new Point(66, 132);
            }
            case 17: {
                return new Point(66, 88);
            }
        }
        System.err.println("Could not find screen position for note " + i);
        return null;
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        if (arg0.getPropertyName().equals("FDChange")) {
            this.updateState((FoodDiagram)arg0.getNewValue());
        }
    }
}

