/*
 * Decompiled with CFR 0.152.
 */
package cbg.ui;

import cbg.boardParts.Card;
import cbg.common.InvalidCardPlayException;
import cbg.common.UIConsts;
import cbg.player.EssenceAndPersonality;
import cbg.player.Player;
import cbg.ui.ConsciousBoardgameGUI;
import cbg.ui.IconFactory;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class EssencePersonalityPanel
extends JPanel
implements UIConsts {
    private CardPane[] epPanes;

    public EssencePersonalityPanel() {
        JPanel facePanel = new JPanel(new GridLayout(3, 12, 5, 2));
        this.epPanes = new CardPane[IconFactory.faceCardIcons.length];
        int i = 0;
        while (i < this.epPanes.length) {
            this.epPanes[i] = new CardPane(IconFactory.faceCardIcons[i]);
            facePanel.add(this.epPanes[i]);
            ++i;
        }
        this.add(facePanel);
    }

    protected void action_CreateJO(Player p) {
        try {
            p.getEp().createJoker();
            short[] sArray = new short[4];
            sArray[3] = 1;
            p.getFd().performShocks(sArray);
        }
        catch (InvalidCardPlayException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Invalid Joker Play", 0);
            return;
        }
        ConsciousBoardgameGUI.getInstance().getMkJOButton().setEnabled(false);
        this.clearSelectedButtons();
    }

    protected void action_CreateXJ(Player p) {
        ArrayList selCards = this.getSelectedAces();
        if (selCards.size() != 2) {
            JOptionPane.showMessageDialog(this, "You must combine 2 aces to make an extra joker.", "Invalid Ace Play", 0);
            return;
        }
        short[] shocks = new short[4];
        try {
            shocks = p.getEp().createXJ((Card)selCards.get(0), (Card)selCards.get(1));
            p.getFd().performShocks(shocks);
        }
        catch (InvalidCardPlayException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Invalid XJ Play", 0);
            return;
        }
        ConsciousBoardgameGUI.getInstance().getMkXJButton().setEnabled(false);
        this.clearSelectedButtons();
    }

    protected void action_CreateAce(Player p) {
        ArrayList selCards = this.getSelectedFaceCards();
        if (selCards.size() != 2) {
            JOptionPane.showMessageDialog(this, "You must combine 2 pieces to make an ace.", "Invalid Transform Play", 0);
            return;
        }
        short[] shocks = new short[4];
        try {
            shocks = p.getEp().createAce((Card)selCards.get(0), (Card)selCards.get(1));
            p.getFd().performShocks(shocks);
        }
        catch (InvalidCardPlayException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Invalid Transform Play", 0);
            return;
        }
        ConsciousBoardgameGUI.getInstance().getMkAceButton().setEnabled(false);
        this.clearSelectedButtons();
    }

    private ArrayList getSelectedFaceCards() {
        ArrayList<Card> selected = new ArrayList<Card>();
        int i = 6;
        while (i < this.epPanes.length) {
            if (this.epPanes[i].isSelected()) {
                selected.add(EssencePersonalityPanel.getCardForPane(i));
            }
            ++i;
        }
        return selected;
    }

    private ArrayList getSelectedAces() {
        ArrayList<Card> selected = new ArrayList<Card>();
        int i = 0;
        while (i < 3) {
            if (this.epPanes[i].isSelected()) {
                selected.add(EssencePersonalityPanel.getCardForPane(i));
            }
            ++i;
        }
        return selected;
    }

    private void clearSelectedButtons() {
        int i = 0;
        while (i < this.epPanes.length) {
            this.epPanes[i].setSelected(false);
            ++i;
        }
    }

    public void updateView(EssenceAndPersonality ep) {
        Iterator iter = ep.getPartsOfBeing().iterator();
        while (iter.hasNext()) {
            Card c = (Card)iter.next();
            this.epPanes[EssencePersonalityPanel.getPaneForCard(c)].setChipCount(ep.getChipsFor(c));
        }
        this.updateUI();
    }

    public static int getPaneForCard(Card c) {
        if (c.getRank() == 14 || c.getSuit() == 0) {
            switch (c.getSuit()) {
                case 0: {
                    if (c.getRank() == 15) {
                        return 4;
                    }
                    if (c.getRank() == 16) {
                        return 5;
                    }
                }
                case 4: {
                    return 0;
                }
                case 3: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
            }
        } else {
            int place = 0;
            switch (c.getSuit()) {
                case 4: {
                    place += 12;
                    break;
                }
                case 3: {
                    place += 15;
                    break;
                }
                case 2: {
                    place += 6;
                    break;
                }
                case 1: {
                    place += 9;
                }
            }
            switch (c.getRank()) {
                case 12: {
                    ++place;
                    break;
                }
                case 13: {
                    place += 2;
                }
            }
            return place;
        }
        System.err.println("Not A Face Card! (did not return)");
        return -1;
    }

    public static Card getCardForPane(int pane) {
        switch (pane) {
            case 0: {
                return Card.AD;
            }
            case 1: {
                return Card.AC;
            }
            case 2: {
                return Card.AH;
            }
            case 3: {
                return Card.AS;
            }
            case 4: {
                return Card.XJ;
            }
            case 5: {
                return Card.JO;
            }
            case 6: {
                return Card.JH;
            }
            case 7: {
                return Card.QH;
            }
            case 8: {
                return Card.KH;
            }
            case 9: {
                return Card.JS;
            }
            case 10: {
                return Card.QS;
            }
            case 11: {
                return Card.KS;
            }
            case 12: {
                return Card.JD;
            }
            case 13: {
                return Card.QD;
            }
            case 14: {
                return Card.KD;
            }
            case 15: {
                return Card.JC;
            }
            case 16: {
                return Card.QC;
            }
            case 17: {
                return Card.KC;
            }
        }
        System.err.println(String.valueOf(pane) + " is not a valid pane! (return null)");
        return null;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EssencePersonalityPanel.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("EP Panel");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new EssencePersonalityPanel());
        frame.pack();
        frame.setVisible(true);
    }

    private class CardPane
    extends Box {
        private JToggleButton cardButton;
        private JLabel pieceLabel;

        public CardPane(ImageIcon icon) {
            super(1);
            this.cardButton = new JToggleButton(icon);
            this.cardButton.setBorderPainted(false);
            this.cardButton.setContentAreaFilled(true);
            this.cardButton.setAlignmentX(0.5f);
            this.cardButton.setAlignmentY(0.5f);
            this.pieceLabel = new JLabel(IconFactory.zeroPieceIcon);
            this.pieceLabel.setAlignmentX(0.5f);
            this.pieceLabel.setAlignmentY(0.5f);
            this.add(this.cardButton);
            this.add(this.pieceLabel);
            this.setMaximumSize(new Dimension(30, 75));
            this.setEnabled(false);
        }

        private void setChipCount(int i) {
            if (i > 0) {
                this.setEnabled(true);
            }
            if (i < 6) {
                this.pieceLabel.setIcon(IconFactory.chipIcons[i]);
            } else {
                this.pieceLabel.setIcon(IconFactory.chipIcons[5]);
            }
        }

        private boolean isSelected() {
            return this.cardButton.isSelected();
        }

        private void setSelected(boolean sel) {
            this.cardButton.setSelected(sel);
        }
    }
}

