/*
 * Decompiled with CFR 0.152.
 */
package cbg.ui;

import cbg.boardParts.Board;
import cbg.boardParts.Card;
import cbg.boardParts.Decks;
import cbg.boardParts.Dice;
import cbg.boardParts.LawCard;
import cbg.common.UIConsts;
import cbg.player.LawEnforcer;
import cbg.player.LevelOfBeing;
import cbg.player.Player;
import cbg.ui.AnimatedBoardPanel;
import cbg.ui.CBGDlgFactory;
import cbg.ui.CardHandPanel;
import cbg.ui.EssencePersonalityPanel;
import cbg.ui.FoodDiagramPanel;
import cbg.ui.IconFactory;
import cbg.ui.LawsInPlayPanel;
import cbg.ui.PickLawsDialog;
import cbg.ui.PlayerStatsPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ConsciousBoardgameGUI
extends JFrame
implements ActionListener,
PropertyChangeListener,
UIConsts {
    public static boolean firstGame = true;
    public static boolean testHasnamuss = false;
    public static boolean testCausal = false;
    public static boolean testKillHasnamuss = false;
    private static final long serialVersionUID = 5184830501394979215L;
    private static ConsciousBoardgameGUI gui = null;
    private Player currentPlayer;
    private String playerName = null;
    int res;
    static final int hSize = 9;
    static final int vSize = 7;
    static final int TOP_MAIN_FRAME = 30;
    static final int LEFT_MAIN_FRAME = 7;
    private AnimatedBoardPanel boardPanel;
    private EssencePersonalityPanel epPanel;
    private CardHandPanel chPanel;
    private FoodDiagramPanel fdPanel;
    private LawsInPlayPanel lipPanel;
    private JPanel buttonPanel = null;
    private PlayerStatsPanel statsPanel;
    private JLabel diceLabel;
    private JButton rollDiceBtn = new JButton("Roll Dice");
    private JButton playButton;
    private JButton mkAceButton;
    private JButton mkXJButton;
    private JButton mkJOButton;
    private boolean isLawDlgShowing = false;

    private ConsciousBoardgameGUI(String title) {
        super(title);
    }

    public static ConsciousBoardgameGUI getInstance() {
        if (gui == null) {
            gui = new ConsciousBoardgameGUI("The Conscious Boardgame v1.5");
        }
        return gui;
    }

    public static void main(String[] args) {
        try {
            testHasnamuss = Boolean.valueOf(args[0]);
            testCausal = Boolean.valueOf(args[1]);
        }
        catch (Exception e) {
            System.out.println("To run a hasnamuss game provide a single run argument: \"true\".");
            System.out.println("Optional second argument for testing Causal Hasnamuss: \"true\".");
        }
        IconFactory.createImageIcons();
        try {
            ConsciousBoardgameGUI.initBoardParts();
            while (!Decks.isLDInit()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConsciousBoardgameGUI.createAndShowGUI();
                System.out.println("finished createAndShowGUI");
            }
        });
    }

    static void initBoardParts() {
        Dice.init();
        Board.init();
        Decks.init();
    }

    static void createAndShowGUI() {
        System.out.println("res in pixels per inch=" + Toolkit.getDefaultToolkit().getScreenResolution());
        System.out.println("screen size=" + Toolkit.getDefaultToolkit().getScreenSize().width + "X" + Toolkit.getDefaultToolkit().getScreenSize().height);
        ConsciousBoardgameGUI.getInstance().setDefaultCloseOperation(3);
        ConsciousBoardgameGUI.getInstance().setCurrentPlayer(new Player());
        Component abPanel = ConsciousBoardgameGUI.getInstance().createABPanel();
        Component foodDiag = ConsciousBoardgameGUI.getInstance().createFoodDiagramPane();
        Component epDiag = ConsciousBoardgameGUI.getInstance().createEPDiagram();
        Component ch = ConsciousBoardgameGUI.getInstance().createCardHandPane();
        Component btns = ConsciousBoardgameGUI.getInstance().createButtonPane();
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(btns, "First");
        mainPanel.add(epDiag, "Center");
        mainPanel.add(foodDiag, "After");
        System.out.println("Preferred sizes: mainPanel=" + mainPanel.getPreferredSize() + ";btns=" + btns.getPreferredSize() + ";epDiag=" + epDiag.getPreferredSize() + ";foodDiag=" + foodDiag.getPreferredSize() + ";cardHand=" + ch.getPreferredSize());
        abPanel.setMaximumSize(abPanel.getPreferredSize());
        mainPanel.setMaximumSize(mainPanel.getPreferredSize());
        System.out.println("Max size: mainPanel=" + mainPanel.getMaximumSize() + "\nabPanel=" + abPanel.getMaximumSize());
        Box box = new Box(1);
        box.add(Box.createVerticalGlue());
        box.add(abPanel);
        box.add(Box.createVerticalGlue());
        box.add(mainPanel);
        box.add(Box.createVerticalGlue());
        box.add(ch);
        JScrollPane scrollPane = new JScrollPane(box);
        scrollPane.setLocation(7, 30);
        Insets inset = ConsciousBoardgameGUI.getInstance().getInsets();
        Dimension prefSize = scrollPane.getPreferredSize();
        scrollPane.setBounds(inset.left, inset.top, prefSize.width, prefSize.height);
        ConsciousBoardgameGUI.getInstance().getContentPane().setPreferredSize(scrollPane.getPreferredSize());
        System.out.println("Preferred sizes: box=" + box.getPreferredSize() + ";scrollPane=" + scrollPane.getPreferredSize() + ";CBGUI.getContentPane()=" + ConsciousBoardgameGUI.getInstance().getContentPane().getPreferredSize());
        ConsciousBoardgameGUI.getInstance().getContentPane().setLayout(new BorderLayout());
        ConsciousBoardgameGUI.getInstance().getContentPane().add((Component)scrollPane, "Center");
        ConsciousBoardgameGUI.getInstance().pack();
        ConsciousBoardgameGUI.getInstance().setVisible(true);
        box.revalidate();
        if (firstGame) {
            ConsciousBoardgameGUI.getInstance().playerName = JOptionPane.showInputDialog(ConsciousBoardgameGUI.getInstance(), (Object)"Hi, What is your name?");
        }
        ConsciousBoardgameGUI.getInstance().startGame();
    }

    private void startGame() {
        if (this.playerName != null && this.playerName.length() > 0) {
            this.currentPlayer.setName(this.playerName);
            this.statsPanel.setPlayerName(this.playerName);
        }
        this.currentPlayer.initGame();
        String msg = "You start off with 2 law plays and 2 card plays this turn.\nYou are type " + this.currentPlayer.getType() + "\nGood Luck!";
        String title = "Welcome";
        if (firstGame) {
            msg = "Welcome to The Conscious Video Game, " + this.currentPlayer.getName() + "\n" + msg;
            firstGame = false;
        } else {
            title = "New Game";
        }
        JOptionPane.showMessageDialog(this, msg, title, -1);
        this.showLawsDialog(false);
    }

    public void showLawsDialog(boolean choiceOnly) {
        final PickLawsDialog pickLawsDlg = new PickLawsDialog(this);
        if (choiceOnly) {
            pickLawsDlg.createChoiceDialog();
        } else {
            pickLawsDlg.createAndShowDialog();
        }
        final JDialog dialog = new JDialog(this, "Pick Law Card Panel", false);
        dialog.setContentPane(pickLawsDlg.getContentPane());
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), "You must pick your laws for this turn.", "Law Selection", 1);
            }
        });
        pickLawsDlg.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (dialog.isVisible() && e.getSource() == pickLawsDlg && prop.equals("finished") && ((Boolean)e.getNewValue()).booleanValue()) {
                    dialog.setVisible(false);
                    ConsciousBoardgameGUI.this.isLawDlgShowing = false;
                    if (ConsciousBoardgameGUI.this.currentPlayer.getLawsInPlay().size() > 0) {
                        ConsciousBoardgameGUI.getInstance().showLawsInPlayPanel();
                    }
                }
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        this.isLawDlgShowing = true;
    }

    private void showLawsInPlayPanel() {
        this.lipPanel.updateView(this.currentPlayer);
        this.lipPanel.setVisible(true);
    }

    public void addLawToPlay(LawCard lc) {
        this.currentPlayer.addLawToPlay(lc);
        this.lipPanel.updateView(this.currentPlayer);
    }

    private Component createFoodDiagramPane() {
        Box box = new Box(1);
        box.add(Box.createVerticalGlue());
        this.fdPanel = new FoodDiagramPanel();
        this.statsPanel = new PlayerStatsPanel(this.currentPlayer.getName());
        box.add(this.statsPanel);
        box.add(this.fdPanel);
        this.currentPlayer.addPropertyChangeListener(this.statsPanel);
        this.currentPlayer.getFd().addPropertyChangeListener(this.statsPanel);
        this.currentPlayer.getFd().addPropertyChangeListener(this.fdPanel);
        this.currentPlayer.getFd().addPropertyChangeListener(this);
        box.setPreferredSize(new Dimension(286, 264 + this.statsPanel.getHeight()));
        box.setMaximumSize(box.getPreferredSize());
        return box;
    }

    private Component createButtonPane() {
        this.buttonPanel = new JPanel();
        this.playButton = new JButton("Play Selected Cards");
        this.mkAceButton = new JButton("Make Ace");
        this.mkXJButton = new JButton("Make Extra Joker");
        this.mkJOButton = new JButton("Make Joker");
        this.diceLabel = new JLabel("0");
        this.rollDiceBtn.setActionCommand("ROLL");
        this.rollDiceBtn.addActionListener(this);
        this.playButton.setActionCommand("PLAY");
        this.playButton.addActionListener(this);
        this.mkAceButton.setActionCommand("MKACE");
        this.mkAceButton.addActionListener(this);
        this.mkAceButton.setVisible(false);
        this.mkXJButton.setActionCommand("MKXJ");
        this.mkXJButton.addActionListener(this);
        this.mkXJButton.setVisible(false);
        this.mkJOButton.setActionCommand("MKJO");
        this.mkJOButton.addActionListener(this);
        this.mkJOButton.setVisible(false);
        this.diceLabel.setIcon(IconFactory.diceIcon);
        this.diceLabel.setForeground(Color.WHITE);
        this.diceLabel.setHorizontalAlignment(0);
        this.diceLabel.setHorizontalTextPosition(0);
        this.diceLabel.setVerticalTextPosition(0);
        this.diceLabel.setText("" + Dice.getRoll());
        this.diceLabel.setVisible(true);
        this.buttonPanel.setAlignmentX(0.0f);
        this.buttonPanel.add(this.rollDiceBtn);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.buttonPanel.add(this.diceLabel);
        this.buttonPanel.add(this.playButton);
        this.buttonPanel.add(this.mkAceButton);
        this.buttonPanel.add(this.mkXJButton);
        this.buttonPanel.add(this.mkJOButton);
        this.currentPlayer.getEp().addPropertyChangeListener(this);
        this.buttonPanel.setPreferredSize(new Dimension(840, 30));
        return this.buttonPanel;
    }

    public Component getButtonPanel() {
        return this.buttonPanel;
    }

    private Component createCardHandPane() {
        this.chPanel = new CardHandPanel();
        this.currentPlayer.addPropertyChangeListener(this.chPanel);
        this.chPanel.updateHandView(this.currentPlayer.getPocHand());
        return this.chPanel;
    }

    private Component createABPanel() {
        this.boardPanel = new AnimatedBoardPanel();
        this.boardPanel.setPreferredSize(new Dimension(840, 21));
        return this.boardPanel;
    }

    private Component createEPDiagram() {
        Box box = new Box(1);
        this.epPanel = new EssencePersonalityPanel();
        this.epPanel.updateView(this.currentPlayer.getEp());
        this.lipPanel = new LawsInPlayPanel();
        this.lipPanel.setVisible(false);
        this.lipPanel.setPreferredSize(new Dimension(444, 100));
        box.add(this.epPanel);
        box.add(this.lipPanel);
        box.setPreferredSize(new Dimension(444, 288 + 2 * IconFactory.chipIcons[2].getIconHeight() + IconFactory.chipIcons[4].getIconHeight() + this.lipPanel.getPreferredSize().height));
        box.setMaximumSize(box.getPreferredSize());
        return box;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("ROLL".equals(cmd)) {
            this.rollDiceCommand();
        } else if ("DISCARDASTRAL".equals(cmd)) {
            this.currentPlayer.getFd().discardAstral();
            this.currentPlayer.getFd().forceChange();
            this.rollDiceBtn.setActionCommand("ROLL");
            this.rollDiceBtn.setText("Roll Dice");
        } else if ("PLAY".equals(cmd)) {
            if (this.currentPlayer.isAsleep()) {
                JOptionPane.showMessageDialog(this, "You are asleep.\nYou can not play cards while sleeping.\n", "Wake up!", 0);
                this.lipPanel.deselectAllButtons();
                this.chPanel.deselectAllButtons();
                return;
            }
            short[] shocks = new short[4];
            shocks = this.lipPanel.isVisible() && this.lipPanel.getSelectedLawCards(this.currentPlayer).size() > 0 ? this.lipPanel.playSelectedCards(this.currentPlayer, this.chPanel) : this.chPanel.playSelectedCards(this.currentPlayer);
            this.currentPlayer.getFd().performShocks(shocks);
        } else if ("MKACE".equals(cmd)) {
            if (this.currentPlayer.isAsleep()) {
                JOptionPane.showMessageDialog(this, "You are asleep.\nYou can not transform emotions while sleeping.\n", "Wake up!", 0);
                this.lipPanel.deselectAllButtons();
                this.chPanel.deselectAllButtons();
                return;
            }
            this.epPanel.action_CreateAce(this.currentPlayer);
        } else if ("MKXJ".equals(cmd)) {
            if (this.currentPlayer.isAsleep()) {
                JOptionPane.showMessageDialog(this, "You are asleep.\nYou can not make Extra-Jokers while sleeping.\n", "Wake up!", 0);
                this.lipPanel.deselectAllButtons();
                this.chPanel.deselectAllButtons();
                return;
            }
            this.epPanel.action_CreateXJ(this.currentPlayer);
        } else if ("MKJO".equals(cmd)) {
            if (this.currentPlayer.isAsleep()) {
                JOptionPane.showMessageDialog(this, "You are asleep.\nYou can not make Jokers while sleeping.\n", "Wake up!", 0);
                this.lipPanel.deselectAllButtons();
                this.chPanel.deselectAllButtons();
                return;
            }
            this.epPanel.action_CreateJO(this.currentPlayer);
        } else if ("OBEYLAW".equals(cmd)) {
            this.obeyLaw();
        } else if ("DIE!".equals(cmd)) {
            ConsciousBoardgameGUI.instantDeath(this.currentPlayer);
        } else if ("KEEPSELECTED".equals(cmd)) {
            if (this.chPanel.getSelectedCards(this.currentPlayer).size() > 7) {
                JOptionPane.showMessageDialog(this, "You may only keep up to 7 cards from your hand.\nChoose the cards you want to keep and press the\n'Keep Selected Cards' button to accept your choice.", "Pick 7", 0);
            } else {
                this.chPanel.keepSelectedCards(this.currentPlayer);
                this.playButton.setText("Play Selected Cards");
                this.playButton.setActionCommand("PLAY");
                this.rollDiceBtn.setEnabled(true);
                this.rollDiceBtn.doClick();
            }
        }
        if (this.currentPlayer.getEp().isComplete(this.currentPlayer.isHasnamuss())) {
            if (this.currentPlayer.isHasnamuss() && this.currentPlayer.getEp().cleansedHasnamuss()) {
                CBGDlgFactory.displayInformationMessage("Redemption", "Congratulations!\nYou have cleansed yourself of being a Hasnamuss.\nYou give up a Joker piece in exchange for your soul.");
                this.currentPlayer.cleanseHasnamuss();
                this.currentPlayer.getEp().removeJoker();
            }
            this.currentPlayer.getEp().setComplete(true);
            this.currentPlayer.getFd().checkComplete();
        }
        this.updateView();
    }

    public static void instantDeath(Player plyr) {
        if (plyr.survivesDeath()) {
            ConsciousBoardgameGUI.getInstance().rollDiceBtn.setText("Roll Dice");
            ConsciousBoardgameGUI.getInstance().rollDiceBtn.setActionCommand("ROLL");
            plyr.startDeathGame();
            ConsciousBoardgameGUI.getInstance().rollDiceBtn.doClick();
        } else {
            CBGDlgFactory.endGameMessage("\"Blessed is he who has a soul,\nBlessed is he who has none,\nBut woah and grief to him who has it in embryo.\"\nAlthough you did not aquire a soul during this life,\nthat's no reason you can't just start another game!\nPlay Again?");
        }
    }

    private void obeyLaw() {
        ArrayList selLaw;
        if (testHasnamuss) {
            int i = 0;
            while (i < 15) {
                this.currentPlayer.drawPOCCard(true);
                ++i;
            }
            this.currentPlayer.getEp().createTwoPieces(Card.AD);
            this.currentPlayer.getEp().createTwoPieces(Card.AC);
            this.currentPlayer.getEp().createTwoPieces(Card.AH);
            this.currentPlayer.getEp().createTwoPieces(Card.AS);
            this.currentPlayer.getEp().createTwoPieces(Card.XJ);
            this.currentPlayer.getEp().createTwoPieces(Card.QH);
            this.currentPlayer.getEp().createTwoPieces(Card.JH);
            this.currentPlayer.getEp().createTwoPieces(Card.QS);
            this.currentPlayer.getEp().createTwoPieces(Card.JS);
            this.currentPlayer.getEp().createTwoPieces(Card.QD);
            this.currentPlayer.getEp().createTwoPieces(Card.KD);
            LawEnforcer.enforceLawOnPlayer(Decks.test_DrawJokerLaw(), ConsciousBoardgameGUI.getInstance().getCurrentPlayer(), true);
            this.currentPlayer.getEp().createPiece(Card.JO);
            short[] sArray = new short[8];
            sArray[7] = 9;
            short[] f = sArray;
            short[] sArray2 = new short[6];
            sArray2[3] = 1;
            sArray2[5] = 6;
            short[] a = sArray2;
            short[] sArray3 = new short[4];
            sArray3[3] = 3;
            short[] i2 = sArray3;
            this.currentPlayer.getFd().enterChips(f, a, i2);
            if (testCausal) {
                short[] sArray4 = new short[8];
                sArray4[7] = 6;
                f = sArray4;
                short[] sArray5 = new short[6];
                sArray5[3] = 1;
                sArray5[5] = 5;
                a = sArray5;
                short[] sArray6 = new short[4];
                sArray6[3] = 3;
                i2 = sArray6;
                this.currentPlayer.getFd().enterChips(f, a, i2);
                testCausal = false;
                testKillHasnamuss = true;
            }
            testHasnamuss = false;
        }
        if ((selLaw = this.lipPanel.getSelectedLawCards(this.currentPlayer)).size() != 1) {
            JOptionPane.showMessageDialog(this, "You can only obey one law card at a time.", "Grace", 1);
            this.lipPanel.deselectAllButtons();
            return;
        }
        LawCard lc = (LawCard)selLaw.remove(0);
        if (lc.isObeyed()) {
            JOptionPane.showMessageDialog(this, "You already obeyed the " + lc.getCard() + " law card.", "Double Jeopardy", 1);
            this.lipPanel.deselectAllButtons();
            return;
        }
        LawEnforcer.enforceLawOnPlayer(lc, this.currentPlayer, false);
        this.lipPanel.deselectAllButtons();
    }

    private void rollDiceCommand() {
        if (testKillHasnamuss) {
            this.currentPlayer.dies();
            testKillHasnamuss = false;
        }
        if (this.isLawDlgShowing) {
            JOptionPane.showMessageDialog(this, "There's no escape from the long arm of The Law.\nYou must choose and obey law cards before proceeding.", "There's no escaping The Law", 0);
            return;
        }
        if (!this.currentPlayer.hasObeyedLaws()) {
            JOptionPane.showMessageDialog(this, "You must obey all law cards in play before proceeding.", "No escaping the law", 0);
            return;
        }
        if (this.lipPanel.isVisible()) {
            this.lipPanel.setVisible(false);
        }
        int roll = Dice.roll() * this.currentPlayer.getRollMultiple();
        if (this.currentPlayer.getBoardPos() + roll > Board.getNumSpaces() - 1) {
            roll = Board.getNumSpaces() - 1 - this.currentPlayer.getBoardPos();
        }
        roll = CBGDlgFactory.showDiceOptionDialog(this.currentPlayer, roll);
        this.diceLabel.setText(String.valueOf(Dice.getRoll()));
        this.enableRoll(false);
        if (this.currentPlayer.getBoardPos() + roll > Board.getNumSpaces() - 1) {
            roll = Board.getNumSpaces() - 1 - this.currentPlayer.getBoardPos();
        }
        System.out.println("moving " + roll + " spaces");
        this.boardPanel.restart(roll, this.currentPlayer.getBoardPos());
        this.currentPlayer.move(roll);
        this.statsPanel.setAge(this.currentPlayer.getAge());
        this.enablePowerButtons();
        if (this.currentPlayer.getLawPlaysThis() > 0) {
            this.showLawsDialog(false);
        }
    }

    void enableRoll(boolean b) {
        this.rollDiceBtn.setEnabled(b);
    }

    public void keepSelectedCardsConfig() {
        this.playButton.setText("Keep Selected Cards (roll after death)");
        this.playButton.setActionCommand("KEEPSELECTED");
        this.disablePowerButtons();
        this.rollDiceBtn.setEnabled(false);
        JOptionPane.showMessageDialog(this, "Before you enter the 'afterlife', you may\nkeep up to 7 cards from your hand.\nChoose the cards you want to keep and press the\n'Keep Selected Cards' button to accept your choice.", "Pick 7", 1);
    }

    private void enablePowerButtons() {
        if (this.currentPlayer.getBoardPos() > this.currentPlayer.getNoPowersTil()) {
            if (this.currentPlayer.getEp().foundSchool()) {
                this.getMkAceButton().setEnabled(true);
            }
            if (this.currentPlayer.getEp().hasAprilFools()) {
                this.getMkXJButton().setEnabled(true);
            }
            if (this.currentPlayer.getEp().has1001Words()) {
                this.getMkJOButton().setEnabled(true);
            }
        }
    }

    public void disablePowerButtons() {
        this.getMkAceButton().setEnabled(false);
        this.getMkXJButton().setEnabled(false);
        this.getMkJOButton().setEnabled(false);
    }

    public void lastTurn() {
        this.rollDiceBtn.setText("End Turn (Roll)");
        this.rollDiceBtn.setActionCommand("DIE!");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("LevelofBeing")) {
            LevelOfBeing lob = (LevelOfBeing)evt.getNewValue();
            if (lob.getLevel().equals("Student")) {
                this.mkAceButton.setVisible(true);
                this.mkAceButton.setEnabled(true);
                JOptionPane.showMessageDialog(this, "You found a school.\nYou can now play two cards per turn.\nNew Skill: You can breathe when you eat once per turn.\nNew Power: You can transform emotions by combining two\ndifferent face cards of the same suit, creating an ace\nof that suit, once per turn.\nNew Aim: Put a piece on all four Aces for Steward.", "Found School!", -1);
            } else if (lob.getLevel().equals("Steward")) {
                this.mkXJButton.setVisible(true);
                this.mkXJButton.setEnabled(true);
                JOptionPane.showMessageDialog(this, "April Fools!\nYou can now play three cards per turn.\nNew Dice Option: You can re-roll once\nif you don't like your roll.\nNew Skill: You can eat when you breathe once per turn.\nNew Power: You can make Extra Jokers by combining two\ndifferent aces of hearts, clubs, or diamonds.\nNew Aim: Put a piece on the Joker by bumping through\nthe Extra-Joker to become a Master.", "April Fools!", -1);
            } else if (lob.getLevel().equals("Master")) {
                this.mkJOButton.setVisible(true);
                this.mkJOButton.setEnabled(true);
                JOptionPane.showMessageDialog(this, "You 'Mastered' 1001 words flawlessly.\nYou can now play four cards per turn.\nNew Dice Option: You can take the opposite\nside of the " + Dice.getNumSides() + "-sided die as your roll.\n" + "New Skill: You can 'carbon-12' a new impression 48 once per turn.\n" + "New Power: You can create Jokers by combining\n" + "an Extra Joker with an Ace of Spades.\n" + "New Aim: Put three pieces on the Joker and\n" + "complete your Mental body to Start Over!", "Mastery!", -1);
            }
            this.currentPlayer.giveMCMoment();
            this.statsPanel.updateLob(lob.getLevel());
        } else if (evt.getPropertyName().equals("EPComplete")) {
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                this.currentPlayer.getFd().checkComplete();
                if (this.currentPlayer.getFd().isComplete()) {
                    CBGDlgFactory.showGameCompleted();
                }
            }
        } else if (evt.getPropertyName().equals("FoodDiagComplete") && this.currentPlayer.getEp().isComplete(this.currentPlayer.isHasnamuss())) {
            CBGDlgFactory.showGameCompleted();
        } else if (evt.getPropertyName().equals("DiscardAstral")) {
            this.rollDiceBtn.setText("Discard Astral Body");
            this.rollDiceBtn.setActionCommand("DISCARDASTRAL");
        }
    }

    public JButton getMkAceButton() {
        return this.mkAceButton;
    }

    public JButton getMkJOButton() {
        return this.mkJOButton;
    }

    public JButton getMkXJButton() {
        return this.mkXJButton;
    }

    private void updateView() {
        this.statsPanel.updateActiveLawsLabel(this.currentPlayer.getActiveLaws());
        this.epPanel.updateView(this.currentPlayer.getEp());
        this.chPanel.updateHandView(this.currentPlayer.getPocHand());
        this.boardPanel.repaint();
        this.update(this.getGraphics());
    }

    public Player getCurrentPlayer() {
        return ConsciousBoardgameGUI.gui.currentPlayer;
    }

    private void setCurrentPlayer(Player currentPlayer) {
        this.currentPlayer = currentPlayer;
    }

    public void restart() {
        this.removeAll();
        this.dispose();
        gui = null;
        ConsciousBoardgameGUI.initBoardParts();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConsciousBoardgameGUI.createAndShowGUI();
                System.out.println("finished createAndShowGUI");
            }
        });
    }
}

