/*
 * Decompiled with CFR 0.152.
 */
package cbg.ui;

import cbg.boardParts.Card;
import cbg.boardParts.Decks;
import cbg.common.UIConsts;
import cbg.player.Player;
import cbg.ui.CBGDlgFactory;
import cbg.ui.IconFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class CardHandPanel
extends JPanel
implements UIConsts,
PropertyChangeListener {
    JPanel cardPane = new JPanel(new FlowLayout());
    JScrollPane scroller;

    public CardHandPanel() {
        super(new BorderLayout());
        this.cardPane.setPreferredSize(new Dimension(639, 768));
        this.scroller = new JScrollPane(this.cardPane, 20, 31);
        this.scroller.setAlignmentX(3.0f);
        this.add((Component)this.scroller, "Center");
        this.setPreferredSize(new Dimension(639, 100));
        this.setMinimumSize(new Dimension(387, 100));
    }

    public short[] playSelectedCards(Player plyr) {
        ArrayList selected = this.getSelectedCards(plyr);
        int nSelected = selected.size();
        short[] shocks = new short[4];
        if (nSelected > 3) {
            CBGDlgFactory.displayMessage("You can play up to 3 cards at one time.\nYou tried to play " + selected + ".");
            this.deselectAllButtons();
            return shocks;
        }
        if (nSelected > plyr.getCardPlays()) {
            CBGDlgFactory.displayMessage("You have " + plyr.getCardPlays() + " card plays left this turn.\n" + "You tried to play cards " + selected);
            this.deselectAllButtons();
            return shocks;
        }
        if (nSelected == 1) {
            Card c = (Card)selected.get(0);
            if (!c.isFaceCard()) {
                CBGDlgFactory.displayMessage("You can only play a face card by itself.");
                return shocks;
            }
            shocks = plyr.getEp().createPiece(c);
            plyr.getPocHand().remove(c);
            plyr.takeCardPlays(nSelected);
        } else if (nSelected == 2) {
            Card c2;
            Card c1 = (Card)selected.get(0);
            Card newCard = Card.playsWith(c1, c2 = (Card)selected.get(1));
            if (newCard == null) {
                CBGDlgFactory.displayMessage("These cards do not play together.");
                this.deselectAllButtons();
                return shocks;
            }
            shocks = plyr.getEp().createPiece(newCard);
            plyr.getPocHand().remove(c1);
            plyr.getPocHand().remove(c2);
            plyr.takeCardPlays(nSelected);
        } else if (nSelected == 3) {
            Card c3;
            Card c2;
            Card c1 = (Card)selected.get(0);
            Card giveTwo = Card.playTrips(c1, c2 = (Card)selected.get(1), c3 = (Card)selected.get(2));
            if (giveTwo == null) {
                CBGDlgFactory.displayMessage("These cards do not play together.");
                this.deselectAllButtons();
                return shocks;
            }
            shocks = plyr.getEp().createTwoPieces(giveTwo);
            plyr.getPocHand().remove(c1);
            plyr.getPocHand().remove(c2);
            plyr.getPocHand().remove(c3);
            plyr.takeCardPlays(nSelected);
        }
        this.deselectAllButtons();
        return shocks;
    }

    public void keepSelectedCards(Player plyr) {
        ArrayList selCards = this.getSelectedCards(plyr);
        plyr.getPocHand().clear();
        plyr.setPocHand(selCards);
    }

    public void deselectAllButtons() {
        int i = 0;
        while (i < this.cardPane.getComponentCount()) {
            JToggleButton btn = (JToggleButton)this.cardPane.getComponent(i);
            btn.setSelected(false);
            ++i;
        }
    }

    public ArrayList getSelectedCards(Player plyr) {
        ArrayList selCards = new ArrayList();
        int i = 0;
        while (i < this.cardPane.getComponentCount()) {
            JToggleButton btn = (JToggleButton)this.cardPane.getComponent(i);
            if (btn.isSelected()) {
                selCards.add(plyr.getPocHand().get(i));
            }
            ++i;
        }
        return selCards;
    }

    public void updateHandView(Collection cards) {
        this.cardPane.removeAll();
        Iterator it = cards.iterator();
        while (it.hasNext()) {
            Card c = (Card)it.next();
            JToggleButton btn = new JToggleButton(IconFactory.cardIcons[c.getRank()][c.getSuit()]);
            btn.setPreferredSize(new Dimension(71, 96));
            this.cardPane.add(btn);
        }
        this.scroller.setViewportView(this.cardPane);
        this.updateUI();
    }

    public static void main(String[] args) {
        IconFactory.createImageIcons();
        Decks.init();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CardHandPanel.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("Card Hand Panel");
        frame.setDefaultCloseOperation(3);
        CardHandPanel chp = new CardHandPanel();
        ArrayList<Card> c = new ArrayList<Card>();
        int i = 0;
        while (i < 7) {
            c.add(Decks.drawPOCCard());
            ++i;
        }
        chp.updateHandView(c);
        frame.getContentPane().add(chp);
        frame.pack();
        frame.setVisible(true);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("POCHandChange")) {
            this.updateHandView((Collection)event.getNewValue());
        }
    }
}

