/*
 * Decompiled with CFR 0.152.
 */
package cbg.ui;

import cbg.boardParts.AirSpace;
import cbg.boardParts.Board;
import cbg.boardParts.BoardSpace;
import cbg.boardParts.CardSpace;
import cbg.boardParts.Dice;
import cbg.boardParts.FoodSpace;
import cbg.boardParts.ImpSpace;
import cbg.boardParts.LawSpace;
import cbg.common.NoSuchNoteException;
import cbg.common.UIConsts;
import cbg.player.Player;
import cbg.ui.ConsciousBoardgameGUI;
import javax.swing.JOptionPane;

public class CBGDlgFactory
implements UIConsts {
    public static int giveAirChoice() {
        return JOptionPane.showOptionDialog(ConsciousBoardgameGUI.getInstance().getButtonPanel(), "There is an extra piece of air, You can:", "Extra Air", 0, 3, null, ExtraAir, ExtraAir[0]);
    }

    public static int giveImpChoice() {
        return JOptionPane.showOptionDialog(ConsciousBoardgameGUI.getInstance().getButtonPanel(), "There is an extra piece of impression, You can:", "Extra Impression", 0, 3, null, ExtraImp, ExtraImp[0]);
    }

    public static boolean giveBWEChoice(Player plyr) {
        int n;
        if (plyr.getEp().foundSchool() && plyr.hasBwe() && (n = JOptionPane.showConfirmDialog(ConsciousBoardgameGUI.getInstance().getButtonPanel(), "Breathe when you eat?", "Skill", 0)) == 0) {
            plyr.setHasBwe(false);
            return true;
        }
        return false;
    }

    public static boolean giveEWBChoice(Player plyr) {
        int n;
        if (plyr.getEp().hasAprilFools() && plyr.hasEwb() && (n = JOptionPane.showConfirmDialog(ConsciousBoardgameGUI.getInstance().getButtonPanel(), "Eat when you breathe?", "Skill", 0)) == 0) {
            plyr.setHasEwb(false);
            return true;
        }
        return false;
    }

    public static boolean giveSelfRemChoice(Player plyr) {
        int n;
        if (plyr.getEp().has1001Words() && plyr.hasSelfRemember() && (n = JOptionPane.showConfirmDialog(ConsciousBoardgameGUI.getInstance().getButtonPanel(), "Carbon 12?", "Skill", 0)) == 0) {
            plyr.setHasSelfRemember(false);
            return true;
        }
        return false;
    }

    public static void showCausalDeathMessage(Player plyr, String planetName) {
        JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), "As a Hasnamuss with a Causal body, you die.\nThe Planet of your Hasnamuss is: " + planetName + ".\n" + "You will move " + plyr.getRollMultiple() + " times your dice roll.\n" + "Start death with seven cards.\n", "Causal Hasnamuss Death", -1);
    }

    public static void showReincarnationMessage(int numBrains) {
        StringBuffer msg = new StringBuffer("As a Hasnamuss with a Kesdjan body, you do not die.\nYou reincarnated as a " + numBrains + "-brained being.\n");
        if (numBrains < 3) {
            msg.append("One and two-brained beings can only escape reincarnation by cleansing\nand do not escape if they crystallize a Mental (or Causal) body.\n");
        } else {
            msg.append("A three-brained Hasnamuss who dies with a Mental body can move\non to one of the divine planets to cleanse themselves.\n");
        }
        msg.append("You start over as you did at the beginning of the game.");
        JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), msg.toString(), "Astral Hasnamuss Death", -1);
    }

    public static String giveShockChoice() {
        return (String)JOptionPane.showInputDialog(ConsciousBoardgameGUI.getInstance(), "Which shock would you like for your Wild Shock?", "Wild Shock", 3, null, Shocks, null);
    }

    public static void giveWildChoice(Player plyr) {
        Object[] sp = plyr.isDead() ? UIConsts.SpacesAfterDeath : UIConsts.Spaces;
        BoardSpace bs = null;
        String n = (String)JOptionPane.showInputDialog(ConsciousBoardgameGUI.getInstance().getButtonPanel(), "You landed on a wild space, which space do you choose?", "Wild Space", 3, null, sp, null);
        if (n.equals(Spaces[0])) {
            bs = new FoodSpace();
        } else if (n.equals(Spaces[1])) {
            bs = new AirSpace();
        } else if (n.equals(Spaces[2])) {
            bs = new ImpSpace();
        } else if (n.equals(Spaces[3])) {
            bs = new CardSpace();
        } else if (n.equals(Spaces[4])) {
            bs = new LawSpace();
        }
        if (bs != null) {
            ((BoardSpace)bs).landOn(plyr);
        } else {
            System.err.println("Invalid Wild Selection, board space null");
        }
    }

    public static void giveDecayChoice(Player plyr) {
        int decay = Dice.roll();
        if (decay == 0) {
            JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance().getButtonPanel(), "You landed on a decay space, but rolled\na zero, decaying nothing.", "No Decay", -1);
        } else {
            block54: {
                System.out.println("dice has " + Dice.getNumSides() + " sides, sides/3=" + Dice.getNumSides() / 3);
                try {
                    if (decay <= 3) {
                        Object[] foodnotes = plyr.getFd().getFoodNotes();
                        String n = (String)JOptionPane.showInputDialog(ConsciousBoardgameGUI.getInstance().getButtonPanel(), "You decay a food piece,\nWhich food note do you choose to lose?", "Decay Food", 3, null, foodnotes, null);
                        if (n == null && !foodnotes[0].equals("(none)")) {
                            CBGDlgFactory.displayMessage("You cannot cancel the decay choice.\nYou lost the first filled food note.");
                            int i = 0;
                            while (i < FoodNotes.length) {
                                if (!plyr.getFd().takeChip(1, i)) {
                                    ++i;
                                    continue;
                                }
                                break block54;
                            }
                            break block54;
                        }
                        if (n.equals(FoodNotes[0])) {
                            plyr.getFd().takeChip(1, 0);
                        } else if (n.equals(FoodNotes[1])) {
                            plyr.getFd().takeChip(1, 1);
                        } else if (n.equals(FoodNotes[2])) {
                            plyr.getFd().takeChip(1, 2);
                        } else if (n.equals(FoodNotes[3])) {
                            plyr.getFd().takeChip(1, 3);
                        } else if (n.equals(FoodNotes[4])) {
                            plyr.getFd().takeChip(1, 4);
                        } else if (n.equals(FoodNotes[5])) {
                            plyr.getFd().takeChip(1, 5);
                        } else if (n.equals(FoodNotes[6])) {
                            plyr.getFd().takeChip(1, 6);
                        } else if (n.equals(FoodNotes[7])) {
                            plyr.getFd().takeChip(1, 7);
                        } else if (!n.equals("(none)")) {
                            System.err.println("Error: could not find food decay selection: " + n);
                        }
                        break block54;
                    }
                    if (decay >= 7) {
                        Object[] impnotes = plyr.getFd().getImpNotes();
                        String n = (String)JOptionPane.showInputDialog(ConsciousBoardgameGUI.getInstance().getButtonPanel(), "You decay a impression piece,\nWhich impression note do you choose to lose?", "Decay Impression", 3, null, impnotes, null);
                        if (n == null && !impnotes[0].equals("(none)")) {
                            CBGDlgFactory.displayMessage("You cannot cancel the decay choice.\nYou lost the first filled impression.");
                            int i = 0;
                            while (i < ImpNotes.length) {
                                if (!plyr.getFd().takeChip(3, i)) {
                                    ++i;
                                    continue;
                                }
                                break block54;
                            }
                            break block54;
                        }
                        if (n.equals(ImpNotes[0])) {
                            plyr.getFd().takeChip(3, 0);
                        } else if (n.equals(ImpNotes[1])) {
                            plyr.getFd().takeChip(3, 1);
                        } else if (n.equals(ImpNotes[2])) {
                            plyr.getFd().takeChip(3, 2);
                        } else if (n.equals(ImpNotes[3])) {
                            plyr.getFd().takeChip(3, 3);
                        } else if (!n.equals("(none)")) {
                            System.err.println("Error: could not find impression decay selection: " + n);
                        }
                        break block54;
                    }
                    Object[] airnotes = plyr.getFd().getAirNotes();
                    String n = (String)JOptionPane.showInputDialog(ConsciousBoardgameGUI.getInstance().getButtonPanel(), "You decay a air piece,\nWhich air note do you choose to lose?", "Decay Air", 3, null, airnotes, null);
                    if (n == null && !airnotes[0].equals("(none)")) {
                        CBGDlgFactory.displayMessage("You cannot cancel the decay choice.\nYou lost the first filled air note.");
                        int i = 0;
                        while (i < AirNotes.length) {
                            if (!plyr.getFd().takeChip(2, i)) {
                                ++i;
                                continue;
                            }
                            break block54;
                        }
                        break block54;
                    }
                    if (n.equals(AirNotes[0])) {
                        plyr.getFd().takeChip(2, 0);
                    } else if (n.equals(AirNotes[1])) {
                        plyr.getFd().takeChip(2, 1);
                    } else if (n.equals(AirNotes[2])) {
                        plyr.getFd().takeChip(2, 2);
                    } else if (n.equals(AirNotes[3])) {
                        plyr.getFd().takeChip(2, 3);
                    } else if (n.equals(AirNotes[4])) {
                        plyr.getFd().takeChip(2, 4);
                    } else if (n.equals(AirNotes[5])) {
                        plyr.getFd().takeChip(2, 5);
                    } else if (!n.equals("(none)")) {
                        System.err.println("Error: could not find air decay selection: " + n);
                    }
                }
                catch (NoSuchNoteException nsc) {
                    System.err.println(nsc.getMessage());
                    nsc.printStackTrace(System.err);
                }
            }
            plyr.getFd().forceChange();
        }
    }

    public static int showDiceOptionDialog(Player plyr, int roll) {
        BoardSpace landedOn = Board.getSpace(plyr.getBoardPos() + roll);
        if (plyr.isHasnamuss()) {
            if (plyr.hasRollAgain()) {
                roll = plyr.hasOppositeRoll() ? CBGDlgFactory.showOppositeAndRollAgainOption(plyr, landedOn, roll) : CBGDlgFactory.showRollAgainOption(plyr, landedOn, roll);
            } else if (plyr.hasOppositeRoll()) {
                roll = CBGDlgFactory.showOppositeOption(plyr, landedOn, roll);
            } else {
                CBGDlgFactory.displayMessage("You rolled " + roll + " and landed on a " + landedOn + " space.");
            }
            return roll;
        }
        if (!plyr.getEp().hasAprilFools()) {
            if (plyr.hasOppositeRoll()) {
                roll = plyr.hasRollAgain() ? CBGDlgFactory.showOppositeAndRollAgainOption(plyr, landedOn, roll) : CBGDlgFactory.showOppositeOption(plyr, landedOn, roll);
            } else if (plyr.hasRollAgain()) {
                roll = CBGDlgFactory.showRollAgainOption(plyr, landedOn, roll);
            } else {
                CBGDlgFactory.displayMessage("You rolled " + roll + " and landed on a " + landedOn + " space.");
            }
        } else {
            roll = !plyr.getEp().has1001Words() ? (plyr.hasOppositeRoll() ? CBGDlgFactory.showOppositeAndRollAgainOption(plyr, landedOn, roll) : CBGDlgFactory.showRollAgainOption(plyr, landedOn, roll)) : CBGDlgFactory.showOppositeAndRollAgainOption(plyr, landedOn, roll);
        }
        return roll;
    }

    private static int showRollAgainOption(Player plyr, BoardSpace landedOn, int roll) {
        Object[] options = new Object[]{"Take Roll", "Roll Again"};
        int n = JOptionPane.showOptionDialog(ConsciousBoardgameGUI.getInstance().getButtonPanel(), "You moved " + roll + " and landed on a " + landedOn + " space.", "Roll Option", 0, 3, null, options, options[0]);
        if (n == 1) {
            roll = Dice.roll() * plyr.getRollMultiple();
            if (plyr.getBoardPos() + roll >= Board.getNumSpaces()) {
                roll = Board.getNumSpaces() - 1 - plyr.getBoardPos();
            }
            landedOn = Board.getSpace(plyr.getBoardPos() + roll);
            CBGDlgFactory.displayMessage("You moved " + roll + " and landed on a " + landedOn + " space.");
            if (!plyr.getEp().hasAprilFools() || plyr.isHasnamuss()) {
                plyr.setRollAgain(false);
            }
        }
        return roll;
    }

    private static int showOppositeAndRollAgainOption(Player plyr, BoardSpace landedOn, int roll) {
        BoardSpace opposite = Board.getSpace(plyr.getBoardPos() + Dice.getOpposite() * plyr.getRollMultiple());
        Object[] options = new Object[]{"Take Roll", "Roll Again", "Take Opposite"};
        int n = JOptionPane.showOptionDialog(ConsciousBoardgameGUI.getInstance().getButtonPanel(), "You rolled " + roll + " which would land on a " + landedOn + " space.\n" + "The opposite roll (" + Dice.getOpposite() * plyr.getRollMultiple() + ") is space is a " + opposite, "Roll Option", 1, 3, null, options, options[0]);
        if (n == 1) {
            roll = Dice.roll() * plyr.getRollMultiple();
            if (plyr.getBoardPos() + roll >= Board.getNumSpaces()) {
                roll = Board.getNumSpaces() - 1 - plyr.getBoardPos();
            }
            landedOn = Board.getSpace(plyr.getBoardPos() + roll);
            CBGDlgFactory.displayMessage("You rolled " + roll + " and landed on a " + landedOn + " space.");
            if (!plyr.getEp().hasAprilFools() || plyr.isHasnamuss()) {
                plyr.setRollAgain(false);
            }
        } else if (n == 2) {
            roll = plyr.getBoardPos() + Dice.getOpposite() * plyr.getRollMultiple() > Board.getNumSpaces() - 1 ? Board.getNumSpaces() - 1 - plyr.getBoardPos() : Dice.getOpposite() * plyr.getRollMultiple();
            if (!plyr.getEp().has1001Words() || plyr.isHasnamuss()) {
                plyr.setOppositeRoll(false);
            }
        }
        return roll;
    }

    private static int showOppositeOption(Player plyr, BoardSpace landedOn, int roll) {
        BoardSpace opposite = Board.getSpace(plyr.getBoardPos() + Dice.getOpposite() * plyr.getRollMultiple());
        Object[] options = new Object[]{"Take Roll", "Take Opposite"};
        int n = JOptionPane.showOptionDialog(ConsciousBoardgameGUI.getInstance().getButtonPanel(), "You rolled " + roll + " which would land on a " + landedOn + " space.\n" + "The opposite roll (" + Dice.getOpposite() * plyr.getRollMultiple() + ") is space is a " + opposite, "Roll Option", 0, 3, null, options, options[0]);
        if (n == 1) {
            roll = plyr.getBoardPos() + Dice.getOpposite() * plyr.getRollMultiple() > Board.getNumSpaces() - 1 ? Board.getNumSpaces() - 1 - plyr.getBoardPos() : Dice.getOpposite() * plyr.getRollMultiple();
            plyr.setOppositeRoll(false);
        }
        return roll;
    }

    public static void showGameCompleted() {
        Object[] options = new Object[]{"Now", "Maybe later..."};
        int choice = JOptionPane.showOptionDialog(ConsciousBoardgameGUI.getInstance(), "You have completed all aspects of yourself,\nthere is nothing more to do but start over.\n\"I Start Over!\"", "Play Again?", 0, 3, null, options, options[0]);
        if (choice == 0) {
            ConsciousBoardgameGUI.getInstance().restart();
        } else {
            ConsciousBoardgameGUI.getInstance().dispose();
            System.exit(0);
        }
    }

    public static void displayMessage(String text) {
        if (ConsciousBoardgameGUI.getInstance() != null && ConsciousBoardgameGUI.getInstance().isVisible()) {
            JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance().getButtonPanel(), text);
        }
    }

    public static void displayInformationMessage(String title, String msg) {
        if (ConsciousBoardgameGUI.getInstance() != null && ConsciousBoardgameGUI.getInstance().isVisible()) {
            JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), msg, title, 1);
        }
    }

    public static void displayErrorMessage(String title, String msg) {
        if (ConsciousBoardgameGUI.getInstance() != null && ConsciousBoardgameGUI.getInstance().isVisible()) {
            JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), msg, title, 0);
        }
    }

    public static void showSleepMessage(String stuff) {
        JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance().getButtonPanel(), "You are asleep, no " + stuff + " for you.", "Asleep", 1);
    }

    public static void endGameMessage(String msg) {
        int choice = JOptionPane.showConfirmDialog(ConsciousBoardgameGUI.getInstance(), msg, "Play Again?", 0);
        if (choice == 0) {
            ConsciousBoardgameGUI.getInstance().restart();
        } else {
            ConsciousBoardgameGUI.getInstance().dispose();
            System.exit(0);
        }
    }
}

