/*
 * Decompiled with CFR 0.152.
 */
package cbg.ui;

import cbg.boardParts.Board;
import cbg.common.UIConsts;
import cbg.ui.ConsciousBoardgameGUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Ellipse2D;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AnimatedBoardPanel
extends JPanel
implements Runnable,
UIConsts {
    private Thread runner;
    public static final int Speed = 200;
    int currPlyrPosition = 0;
    int firstBoardSpace = 0;
    int roll = 0;

    private void setFirstBoardSpace(int p) {
        this.firstBoardSpace = p;
    }

    private void setRoll(int r) {
        this.roll = r;
    }

    public void restart(int currRoll, int startOn) {
        if (this.runner != null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setRoll(currRoll);
        this.setFirstBoardSpace(startOn);
        this.runner = new Thread(this);
        this.runner.start();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        thisThread = Thread.currentThread();
        ** GOTO lbl23
        {
            ++this.currPlyrPosition;
            this.repaint();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException var2_3) {
                // empty catch block
            }
            do {
                if (this.currPlyrPosition < this.roll) continue block4;
                while (this.currPlyrPosition > 0) {
                    ++this.firstBoardSpace;
                    --this.currPlyrPosition;
                    this.repaint();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException var2_4) {
                        // empty catch block
                    }
                }
                this.runner = null;
lbl23:
                // 2 sources

            } while (this.runner == thisThread);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConsciousBoardgameGUI.getInstance().enableRoll(true);
            }
        });
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawBoardSpaces(g2);
        this.drawPlayer(new Point(this.currPlyrPosition * 21, 0), g2);
    }

    private void drawBoardSpaces(Graphics2D g2) {
        Color prevColor = g2.getColor();
        int spaceNum = this.firstBoardSpace;
        int lastBoardSpace = 40;
        if (lastBoardSpace > Board.getNumSpaces() - this.firstBoardSpace) {
            lastBoardSpace = Board.getNumSpaces() - this.firstBoardSpace;
        }
        int i = 0;
        while (i < lastBoardSpace) {
            switch (Board.getSpace(i + this.firstBoardSpace).toString().charAt(1)) {
                case 'F': {
                    this.drawFoodSpace(new Point(21 * i, 0), g2);
                    break;
                }
                case 'A': {
                    this.drawAirSpace(new Point(21 * i, 0), g2);
                    break;
                }
                case 'I': {
                    this.drawImpSpace(new Point(21 * i, 0), g2);
                    break;
                }
                case 'L': {
                    this.drawLawCardSpace(new Point(21 * i, 0), g2);
                    break;
                }
                case 'C': {
                    this.drawCardSpace(new Point(21 * i, 0), g2);
                    break;
                }
                case 'W': {
                    this.drawWildSpace(new Point(21 * i, 0), g2);
                    break;
                }
                case 'D': {
                    this.drawCardSpace(new Point(21 * i, 0), g2);
                    break;
                }
            }
            ++spaceNum;
            ++i;
        }
        g2.setColor(prevColor);
    }

    private void drawWildSpace(Point p, Graphics2D g2) {
        g2.setColor(Color.lightGray);
        g2.fill(new Ellipse2D.Double(p.getX(), p.getY(), 21.0, 21.0));
    }

    private void drawFoodSpace(Point p, Graphics2D g2) {
        g2.setColor(Color.yellow);
        g2.fill(new Ellipse2D.Double(p.getX(), p.getY(), 21.0, 21.0));
    }

    private void drawAirSpace(Point p, Graphics2D g2) {
        g2.setColor(Color.blue);
        g2.fill(new Ellipse2D.Double(p.getX(), p.getY(), 21.0, 21.0));
    }

    private void drawImpSpace(Point p, Graphics2D g2) {
        g2.setColor(Color.red);
        g2.fill(new Ellipse2D.Double(p.getX(), p.getY(), 21.0, 21.0));
    }

    private void drawCardSpace(Point p, Graphics2D g2) {
        g2.setColor(Color.orange);
        g2.fill(new Ellipse2D.Double(p.getX(), p.getY(), 21.0, 21.0));
        g2.setColor(Color.black);
        g2.fill(new Ellipse2D.Double(p.getX() + 5.0, p.getY() + 5.0, 10.0, 10.0));
    }

    private void drawLawCardSpace(Point p, Graphics2D g2) {
        g2.setColor(Color.green);
        g2.fill(new Ellipse2D.Double(p.getX(), p.getY(), 21.0, 21.0));
        g2.setColor(Color.red);
        g2.fill(new Ellipse2D.Double(p.getX() + 5.0, p.getY() + 5.0, 10.0, 10.0));
    }

    private void drawPlayer(Point p, Graphics2D g2) {
        g2.setColor(Color.black);
        g2.fillRect((int)p.getX(), (int)p.getY() + 10 - 1, 21, 3);
        g2.fillRect((int)p.getX() + 10 - 1, (int)p.getY(), 3, 21);
    }
}

