/*
 * Decompiled with CFR 0.152.
 */
package cbg.player;

import cbg.boardParts.Board;
import cbg.player.Player;
import cbg.player.PlayerStrategy;
import cbg.ui.CBGDlgFactory;
import cbg.ui.ConsciousBoardgameGUI;
import javax.swing.JOptionPane;

public class ThreeBrainStrategy
extends PlayerStrategy {
    public void dies(Player thePlayer) {
        if (this.survivesDeath(thePlayer)) {
            if (thePlayer.getFd().hasChrystallizedMental()) {
                JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), "You just died.\nFortunately, you aquired a Mental body,\nwhich is immortal within the limits of this solar system.\nYou may continue playing after death as long as it takes\nfor you to complete yourself and Start Over.", "Mental Death", -1);
            } else if (thePlayer.getFd().hasChrystallizedAstral()) {
                JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), "You just died.\nFortunately, you aquired an Astral body during life.\nYou may continue around the board for one full trip,\nafter which your Astral body will decay and you will need\na mental body to survive.", "Astral Death", -1);
            } else {
                System.err.println("You can't survive death without astral or mental body.");
                JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), "You can't survive death without astral or mental body.\nIf you are reading this message, please report this bug\nto the creator of the game, or just pretend like it never\nhappened. Whichever is easier for your conscience.", "Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), "I have some bad news. You just died.\nUnofortunately, the body you aquired during life was not sufficient\nto enable you to withstand the shock of death.\n\nYou have until the end of this turn to complete an Astral body,\nor your game will be over.\n", "A Simple Death", 2);
        }
    }

    public boolean survivesDeath(Player thePlayer) {
        if (thePlayer.getFd().hasChrystallizedMental()) {
            return true;
        }
        return thePlayer.getFd().hasChrystallizedAstral() && thePlayer.boardTrips <= 1;
    }

    public void startDeath(Player thePlayer) {
        System.out.println("start 3-brained being death game");
        thePlayer.isDead = true;
        thePlayer.setRollMultiple(1);
        Board.initDeathBoard();
        thePlayer.getFd().shiftAfterDeath();
        if (thePlayer.firstDeath) {
            if (thePlayer.getPocHand().size() > 7) {
                ConsciousBoardgameGUI.getInstance().keepSelectedCardsConfig();
            } else if (thePlayer.getPocHand().size() < 7) {
                int added = 7 - thePlayer.getPocHand().size();
                int i = 0;
                while (i < added) {
                    thePlayer.drawPOCCard(true);
                    ++i;
                }
                CBGDlgFactory.displayInformationMessage("Draw up to 7", "You drew " + added + " cards to start death.\n");
            }
            thePlayer.firstDeath = false;
        }
    }

    public boolean isHasnamuss() {
        return false;
    }
}

