/*
 * Decompiled with CFR 0.152.
 */
package cbg.player;

import cbg.common.NoSuchNoteException;
import cbg.common.UIConsts;
import cbg.player.FoodDiagram;
import cbg.ui.CBGDlgFactory;

public class RisingChipModel
implements UIConsts {
    private int excessFood;
    private int excessAir;
    private int excessImp;
    private short[] fo;
    private short[] ao;
    private short[] io;

    public RisingChipModel() {
        this.fo = new short[8];
        this.ao = new short[6];
        this.io = new short[4];
    }

    public RisingChipModel(short[] f, short[] a, short[] i) {
        if (f == null) {
            f = new short[8];
        }
        if (a == null) {
            a = new short[6];
        }
        if (i == null) {
            i = new short[4];
        }
        this.fo = f;
        this.ao = a;
        this.io = i;
    }

    public short get(short type, short place) {
        if (type == 1) {
            return this.fo[place];
        }
        if (type == 2) {
            return this.ao[place];
        }
        if (type == 3) {
            return this.io[place];
        }
        System.err.println("RisingChipModel.get(" + type + "," + place + ") invalid.");
        return 0;
    }

    public void set(short type, short place, short value) {
        if (type == 1) {
            this.fo[place] = value;
        } else if (type == 2) {
            this.ao[place] = value;
        } else if (type == 3) {
            this.io[place] = value;
        }
    }

    public void add(short type, short place) {
        if (type == 1) {
            short s = place;
            this.fo[s] = (short)(this.fo[s] + 1);
        } else if (type == 2) {
            short s = place;
            this.ao[s] = (short)(this.ao[s] + 1);
        } else if (type == 3) {
            short s = place;
            this.io[s] = (short)(this.io[s] + 1);
        }
    }

    public boolean hasMoreChips() {
        int i = 0;
        i = 0;
        while (i < 4) {
            if (this.fo[i] > 0) {
                return true;
            }
            if (this.ao[i] > 0) {
                return true;
            }
            if (this.io[i] > 0) {
                return true;
            }
            ++i;
        }
        i = 4;
        while (i < 6) {
            if (this.fo[i] > 0) {
                return true;
            }
            if (this.ao[i] > 0) {
                return true;
            }
            ++i;
        }
        i = 6;
        while (i < 8) {
            if (this.fo[i] > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void advance(FoodDiagram fd) {
        try {
            if (this.fo[7] > 0) {
                if (!fd.hasChip(1, 7)) {
                    fd.putChip(1, 7);
                    this.fo[7] = (short)(this.fo[7] - 1);
                }
                this.excessFood += this.fo[7];
                this.fo[7] = 0;
            }
            if (this.ao[5] > 0) {
                if (!fd.hasChip(2, 5)) {
                    fd.putChip(2, 5);
                    this.ao[5] = (short)(this.ao[5] - 1);
                }
                this.excessAir += this.ao[5];
                this.ao[5] = 0;
            }
            if (this.io[3] > 0) {
                if (!fd.hasChip(3, 3)) {
                    fd.putChip(3, 3);
                    this.io[3] = (short)(this.io[3] - 1);
                }
                this.excessImp += this.io[3];
                this.io[3] = 0;
            }
            while (this.fo[6] > 0) {
                if (!fd.putChip(1, 6)) {
                    CBGDlgFactory.displayMessage("You drew a card by Higher 12.");
                    fd.getPlayer().drawPOCCard(true);
                }
                this.fo[6] = (short)(this.fo[6] - 1);
            }
            while (this.io[2] > 0) {
                if (!fd.putChip(3, 2)) {
                    CBGDlgFactory.displayMessage("You drew a card by Higher 12.");
                    fd.getPlayer().drawPOCCard(true);
                }
                this.io[2] = (short)(this.io[2] - 1);
            }
            if (this.ao[4] > 0) {
                if (!fd.hasChip(2, 4)) {
                    fd.putChip(2, 4);
                    this.ao[4] = (short)(this.ao[4] - 1);
                }
                this.ao[5] = this.ao[4];
                this.ao[4] = 0;
            }
            if (this.fo[5] > 0) {
                if (!fd.hasChip(1, 5)) {
                    fd.putChip(1, 5);
                    this.fo[5] = (short)(this.fo[5] - 1);
                }
                if (fd.has6()) {
                    this.fo[6] = this.fo[5];
                } else if (this.fo[5] > 0) {
                    CBGDlgFactory.displayMessage("No Hydrogen-6 for food.");
                }
                this.fo[5] = 0;
            }
            if (this.io[1] > 0) {
                if (!fd.hasChip(3, 1)) {
                    fd.putChip(3, 1);
                    this.io[1] = (short)(this.io[1] - 1);
                }
                if (fd.has6()) {
                    this.io[2] = this.io[1];
                } else if (this.io[1] > 0) {
                    CBGDlgFactory.displayMessage("No Hydrogen-6 for impression.");
                }
                this.io[1] = 0;
            }
            if (this.ao[3] > 0) {
                if (!fd.hasChip(2, 3)) {
                    fd.putChip(2, 3);
                    this.ao[3] = (short)(this.ao[3] - 1);
                }
                this.ao[4] = this.ao[3];
                this.ao[3] = 0;
            }
            if (this.fo[4] > 0) {
                if (!fd.hasChip(1, 4)) {
                    fd.putChip(1, 4);
                    this.fo[4] = (short)(this.fo[4] - 1);
                }
                if (fd.has12()) {
                    this.fo[5] = this.fo[4];
                } else if (this.fo[4] > 0) {
                    CBGDlgFactory.displayMessage("No Hydrogen-12 for food.");
                }
                this.fo[4] = 0;
            }
            if (this.ao[2] > 0) {
                if (!fd.hasChip(2, 2)) {
                    fd.putChip(2, 2);
                    this.ao[2] = (short)(this.ao[2] - 1);
                }
                while (this.ao[2] > 0) {
                    if (CBGDlgFactory.giveEWBChoice(fd.getPlayer())) {
                        this.ao[3] = (short)(this.ao[3] + 1);
                    } else if (!fd.leaveMI48()) {
                        CBGDlgFactory.displayMessage("<html>Hyper-ventilation!<br>MI-48 is full.</html>");
                    }
                    this.ao[2] = (short)(this.ao[2] - 1);
                }
            }
            if (this.io[0] > 0) {
                if (!fd.hasChip(3, 0)) {
                    fd.putChip(3, 0);
                    this.io[0] = (short)(this.io[0] - 1);
                }
                while (this.io[0] > 0) {
                    if (CBGDlgFactory.giveSelfRemChoice(fd.getPlayer())) {
                        this.io[1] = (short)(this.io[1] + 1);
                        if (fd.takeChip(2, 2)) {
                            CBGDlgFactory.displayMessage("Self-remembering shocks air.");
                            this.ao[3] = (short)(this.ao[3] + 1);
                        }
                    } else if (!fd.leaveDO48()) {
                        CBGDlgFactory.displayMessage("<html>Pouring from the empty into the void.<br>DO-48 is full.</html>");
                    }
                    this.io[0] = (short)(this.io[0] - 1);
                }
            }
            if (this.ao[1] > 0) {
                if (!fd.hasChip(2, 1)) {
                    fd.putChip(2, 1);
                    this.ao[1] = (short)(this.ao[1] - 1);
                }
                if (fd.has24()) {
                    this.ao[2] = this.ao[1];
                } else if (this.ao[1] > 0) {
                    CBGDlgFactory.displayMessage("No Hydrogen-24 for air.");
                }
                this.ao[1] = 0;
            }
            if (this.fo[3] > 0) {
                if (!fd.hasChip(1, 3)) {
                    fd.putChip(1, 3);
                    this.fo[3] = (short)(this.fo[3] - 1);
                }
                if (fd.has24()) {
                    this.fo[4] = this.fo[3];
                } else if (this.fo[3] > 0) {
                    CBGDlgFactory.displayMessage("No Hydrogen-24 for food.");
                }
                this.fo[3] = 0;
            }
            if (this.fo[2] > 0) {
                if (!fd.hasChip(1, 2)) {
                    fd.putChip(1, 2);
                    this.fo[2] = (short)(this.fo[2] - 1);
                }
                while (this.fo[2] > 0) {
                    if (CBGDlgFactory.giveBWEChoice(fd.getPlayer())) {
                        this.fo[3] = (short)(this.fo[3] + 1);
                        this.fo[2] = (short)(this.fo[2] - 1);
                        continue;
                    }
                    if (!fd.leaveMI192()) {
                        CBGDlgFactory.displayMessage("<html>BURRRP - Indigestion!<br>MI-192 is full.</html>");
                    }
                    this.fo[2] = (short)(this.fo[2] - 1);
                }
            }
            if (this.ao[0] > 0) {
                if (!fd.hasChip(2, 0)) {
                    fd.putChip(2, 0);
                    this.ao[0] = (short)(this.ao[0] - 1);
                }
                if (fd.has48()) {
                    while (this.ao[0] > 0) {
                        this.ao[1] = (short)(this.ao[1] + 1);
                        this.ao[0] = (short)(this.ao[0] - 1);
                        if (!fd.takeChip(1, 2)) continue;
                        CBGDlgFactory.displayMessage("Air at RE-96 shocks food.");
                        this.fo[3] = (short)(this.fo[3] + 1);
                    }
                } else if (this.ao[0] > 0) {
                    CBGDlgFactory.displayMessage("No Hydrogen-48 for air.");
                }
                this.ao[0] = 0;
            }
            if (this.fo[1] > 0) {
                if (!fd.hasChip(1, 1)) {
                    fd.putChip(1, 1);
                    this.fo[1] = (short)(this.fo[1] - 1);
                }
                if (fd.has96()) {
                    this.fo[2] = this.fo[1];
                } else if (this.fo[1] > 0) {
                    CBGDlgFactory.displayMessage("No Hydrogen-96 for food.");
                }
                this.fo[1] = 0;
            }
            if (this.fo[0] > 0) {
                if (!fd.hasChip(1, 0)) {
                    fd.putChip(1, 0);
                    this.fo[0] = (short)(this.fo[0] - 1);
                }
                if (fd.has192()) {
                    this.fo[1] = this.fo[0];
                } else if (this.fo[0] > 0) {
                    CBGDlgFactory.displayMessage("No Hydrogen-192 for food.");
                }
                this.fo[0] = 0;
            }
        }
        catch (NoSuchNoteException nsc) {
            System.err.println(nsc.getMessage());
            nsc.printStackTrace(System.err);
        }
    }

    public void process(FoodDiagram diagram) {
        while (this.hasMoreChips()) {
            this.advance(diagram);
        }
        if (this.hasExcess()) {
            diagram.handleNewPieces(this);
        }
    }

    public boolean hasExcess() {
        return this.excessFood > 0 || this.excessAir > 0 || this.excessImp > 0;
    }

    public int excessFood() {
        return this.excessFood;
    }

    public int excessAir() {
        return this.excessAir;
    }

    public int excessImp() {
        return this.excessImp;
    }
}

