/*
 * Decompiled with CFR 0.152.
 */
package cbg.player;

import cbg.boardParts.Board;
import cbg.boardParts.BoardSpace;
import cbg.boardParts.Card;
import cbg.boardParts.Decks;
import cbg.boardParts.Dice;
import cbg.boardParts.LawCard;
import cbg.common.UIConsts;
import cbg.player.EssenceAndPersonality;
import cbg.player.FoodDiagram;
import cbg.player.HasnamussStrategy;
import cbg.player.PlayerStrategy;
import cbg.player.ThreeBrainStrategy;
import cbg.ui.CBGDlgFactory;
import cbg.ui.ConsciousBoardgameGUI;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Player
implements UIConsts {
    protected String name = "Player 1";
    protected int deathSpace = Board.getNumSpaces() - 1;
    protected int boardTrips = 0;
    protected int sleepTilSpace = -1;
    protected int noSkillsTil = -1;
    protected int noPowersTil = -1;
    protected int rollMultiple = 1;
    protected int type;
    protected int age = 0;
    protected int boardPos = 0;
    protected int cardPlaysLeft;
    protected int lawPlaysThis = 0;
    protected boolean isDead = false;
    protected boolean asleep = false;
    protected boolean bwe = false;
    protected boolean ewb = false;
    protected boolean selfRemember = false;
    protected boolean firstDeath = true;
    protected boolean rollAgain = false;
    protected boolean oppositeRoll = false;
    protected ArrayList pocHand;
    protected ArrayList lawHand;
    protected ArrayList lawsInPlay;
    protected ArrayList activeLaws;
    protected FoodDiagram fd;
    protected EssenceAndPersonality ep;
    private PlayerStrategy strategy;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public Player() {
        this.pocHand = new ArrayList(20);
        this.lawHand = new ArrayList(10);
        this.lawsInPlay = new ArrayList(8);
        this.activeLaws = new ArrayList(8);
        this.fd = new FoodDiagram(this);
        this.ep = new EssenceAndPersonality();
        this.strategy = new ThreeBrainStrategy();
        this.setCardPlays(this.ep.getLob().getPlaysPerTurn());
    }

    public void initGame() {
        this.pocHand.clear();
        int i = 0;
        while (i < 7) {
            this.drawPOCCard(true);
            ++i;
        }
        if (ConsciousBoardgameGUI.testHasnamuss) {
            this.drawLawCard(Decks.test_drawLawNumber(61));
            this.drawLawCard(Decks.test_drawLawNumber(43));
            this.drawLawCard(Decks.test_drawLawNumber(21));
        } else {
            i = 0;
            while (i < 3) {
                this.drawLawCard();
                ++i;
            }
        }
        this.lawPlaysThis = 2;
        this.giveMCMoment();
        Dice.setNumSides(6);
        Dice.setHasZero(false);
        this.setType(Dice.roll());
        Dice.init();
        this.getFd().forceChange();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    public void drawPOCCard(boolean forced) {
        if (this.asleep && !forced) {
            System.out.println("You're asleep; No card for you.");
            CBGDlgFactory.showSleepMessage("card");
        } else {
            Card newCard = Decks.drawPOCCard();
            CBGDlgFactory.displayMessage("You drew a " + newCard);
            this.pocHand.add(newCard);
            Collections.sort(this.pocHand);
            this.changes.firePropertyChange("POCHandChange", null, this.pocHand);
        }
    }

    public void drawPOCCard(Card c) {
        this.pocHand.add(c);
        Collections.sort(this.pocHand);
        this.changes.firePropertyChange("POCHandChange", null, this.pocHand);
    }

    public void drawLawCard() {
        this.lawHand.add(Decks.drawLawCard());
    }

    public void drawLawCard(LawCard card) {
        this.lawHand.add(card);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    protected void endTurn() {
        this.bwe = this.ep.foundSchool();
        this.ewb = this.ep.hasAprilFools();
        this.selfRemember = this.ep.has1001Words();
    }

    public void eat() {
        if (this.asleep) {
            System.out.println("You're asleep; No food for you.");
            CBGDlgFactory.showSleepMessage("food");
        } else {
            this.fd.eat();
        }
    }

    public void breathe() {
        if (this.asleep) {
            System.out.println("You're asleep; No air for you.");
            CBGDlgFactory.showSleepMessage("air");
        } else {
            this.fd.breathe();
        }
    }

    public void takeImpression() {
        if (this.asleep) {
            System.out.println("You're asleep; No impression for you.");
            CBGDlgFactory.showSleepMessage("impression");
        } else {
            this.fd.impression();
        }
    }

    public void move(int roll) {
        this.setCardPlays(this.ep.getLob().getPlaysPerTurn());
        if (this.lawPlaysThis > 0) {
            this.lawPlaysThis = 0;
            this.lawsInPlay.clear();
        }
        ++this.age;
        int iCursp = this.getBoardPos();
        if (iCursp + roll >= Board.getNumSpaces()) {
            roll = Board.getNumSpaces() - iCursp - 1;
        }
        if (this.isAsleep() && iCursp + roll > this.getSleepTilSpace()) {
            this.asleep = false;
            this.sleepTilSpace = -1;
            this.removeActiveLaw(19);
        }
        if (iCursp < this.noSkillsTil && iCursp + roll > this.noSkillsTil) {
            this.noSkillsTil = -1;
            this.removeActiveLaw(41);
        }
        if (iCursp < this.noPowersTil && iCursp + roll > this.noPowersTil) {
            this.noPowersTil = -1;
            this.removeActiveLaw(59);
        }
        BoardSpace sp = Board.getSpace(iCursp);
        sp.leave(this);
        int lawsPassed = 0;
        int i = 1;
        while (i < roll) {
            sp = Board.getSpace(iCursp + i);
            String s = sp.passOver();
            if (s != null) {
                ++lawsPassed;
            }
            ++i;
        }
        this.setBoardPos(iCursp += roll);
        sp = Board.getSpace(this.getBoardPos());
        sp.landOn(this);
        if (iCursp >= this.deathSpace) {
            this.dies();
            System.out.println("You just died on space " + iCursp);
        }
        if (iCursp == Board.getNumSpaces() - 1) {
            System.out.println("You made it to the end of the board, reversing direction.\n space #" + iCursp);
            Board.reverseBoard();
            this.setBoardPos(0);
            if (!this.isHasnamuss()) {
                ++this.boardTrips;
            }
        }
        this.lawPlaysThis = lawsPassed;
        i = 0;
        while (i < lawsPassed) {
            this.drawLawCard();
            ++i;
        }
        this.endTurn();
    }

    public void dies() {
        this.strategy.dies(this);
        ConsciousBoardgameGUI.getInstance().lastTurn();
    }

    public void startDeathGame() {
        this.endTurn();
        this.removeAllLawsButJoker();
        this.lawHand.clear();
        this.lawsInPlay.clear();
        this.strategy.startDeath(this);
    }

    public EssenceAndPersonality getEp() {
        return this.ep;
    }

    public void giveMCMoment() {
        this.setCardPlays(this.cardPlaysLeft + 1);
    }

    public int getCardPlays() {
        return this.cardPlaysLeft;
    }

    public void setCardPlays(int n) {
        int oVal = this.getCardPlays();
        this.cardPlaysLeft = n;
        this.changes.firePropertyChange("CardPlaysLeft", oVal, this.cardPlaysLeft);
    }

    public int getAge() {
        return this.age;
    }

    public int getBoardPos() {
        return this.boardPos;
    }

    public void setBoardPos(int pos) {
        this.boardPos = pos;
    }

    public FoodDiagram getFd() {
        return this.fd;
    }

    public ArrayList getLawHand() {
        return this.lawHand;
    }

    public String printLawHand() {
        String retString = "";
        Iterator i = this.lawHand.iterator();
        while (i.hasNext()) {
            retString = String.valueOf(retString) + (LawCard)i.next();
        }
        return retString;
    }

    public List getPocHand() {
        return this.pocHand;
    }

    public void setPocHand(ArrayList a) {
        this.pocHand = a;
        this.changes.firePropertyChange("POCHandChange", null, this.pocHand);
    }

    public String printPocHand() {
        String retString = "^";
        int c = 0;
        Iterator i = this.pocHand.iterator();
        while (i.hasNext()) {
            retString = String.valueOf(retString) + "(" + c++ + ")" + i.next() + "^";
            if (c % 7 != 0) continue;
            retString = String.valueOf(retString) + "\n";
        }
        return retString;
    }

    public String printFoodDiagram() {
        return this.fd.toString();
    }

    public boolean isAsleep() {
        return this.asleep;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public String toString() {
        return "PLAYER " + this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getLawPlaysThis() {
        return this.lawPlaysThis;
    }

    public void setLawPlaysThis(int lawPlays) {
        this.lawPlaysThis = lawPlays;
    }

    public void takeCardPlays(int i) {
        this.setCardPlays(this.cardPlaysLeft - i);
    }

    public ArrayList getLawsInPlay() {
        return this.lawsInPlay;
    }

    public void addLawToPlay(LawCard lc) {
        if (this.lawsInPlay == null) {
            this.lawsInPlay = new ArrayList(12);
        }
        this.lawsInPlay.add(lc);
    }

    public void addActiveLaw(LawCard lc) {
        this.activeLaws.add(lc);
    }

    public void removeActiveLaw(int lawVal) {
        int i = 0;
        while (i < this.activeLaws.size()) {
            if (lawVal == ((LawCard)this.activeLaws.get(i)).getLawValue()) {
                this.activeLaws.remove(i);
                break;
            }
            ++i;
        }
    }

    public void removeAllLawsButJoker() {
        this.deathSpace = Board.getNumSpaces() - 1;
        this.sleepTilSpace = -1;
        this.noSkillsTil = -1;
        this.noPowersTil = -1;
        ArrayList<LawCard> jlist = new ArrayList<LawCard>();
        jlist.add(LawCard.Joker);
        this.activeLaws.retainAll(jlist);
    }

    public ArrayList getActiveLaws() {
        return this.activeLaws;
    }

    public boolean hasObeyedLaws() {
        Iterator it = this.lawsInPlay.iterator();
        while (it.hasNext()) {
            if (((LawCard)it.next()).isObeyed()) continue;
            return false;
        }
        return true;
    }

    public boolean hasBwe() {
        return this.bwe && this.getNoSkillsTil() < this.getBoardPos();
    }

    public void setHasBwe(boolean bwe) {
        this.bwe = bwe;
    }

    public boolean hasEwb() {
        return this.ewb && this.getNoSkillsTil() < this.getBoardPos();
    }

    public void setHasEwb(boolean ewb) {
        this.ewb = ewb;
    }

    public boolean hasSelfRemember() {
        return this.selfRemember && this.getNoSkillsTil() < this.getBoardPos();
    }

    public void setHasSelfRemember(boolean selfRemember) {
        this.selfRemember = selfRemember;
    }

    public int getSleepTilSpace() {
        return this.sleepTilSpace;
    }

    public void setAsleepTil(int sleepTilSpace) {
        this.asleep = true;
        this.sleepTilSpace = sleepTilSpace;
    }

    public int getDeathSpace() {
        return this.deathSpace;
    }

    public void setDeathSpace(int deathSpace) {
        this.deathSpace = deathSpace;
    }

    public boolean survivesDeath() {
        return this.strategy.survivesDeath(this);
    }

    public int getNoPowersTil() {
        return this.noPowersTil;
    }

    public void setNoPowersTil(int noPowersTil) {
        this.noPowersTil = noPowersTil;
    }

    public int getNoSkillsTil() {
        return this.noSkillsTil;
    }

    public void setNoSkillsTil(int noSkillsTil) {
        this.noSkillsTil = noSkillsTil;
    }

    public boolean hasRollAgain() {
        return this.rollAgain;
    }

    public void setRollAgain(boolean rollAgain) {
        this.rollAgain = rollAgain;
    }

    public boolean hasOppositeRoll() {
        return this.oppositeRoll;
    }

    public void setOppositeRoll(boolean oppositeRoll) {
        this.oppositeRoll = oppositeRoll;
    }

    public boolean hasAccidentMoon() {
        return this.activeLaws.contains(LawCard.KingDiamonds);
    }

    public boolean hasCauseEffectMoon() {
        return this.activeLaws.contains(LawCard.KingClubs);
    }

    public boolean hasFateMoon() {
        return this.activeLaws.contains(LawCard.KingHearts);
    }

    public boolean hasWillMoon() {
        return this.activeLaws.contains(LawCard.KingSpades);
    }

    public boolean isHasnamuss() {
        return this.strategy.isHasnamuss();
    }

    public void makeHasnamuss() {
        this.strategy = new HasnamussStrategy();
    }

    public void cleanseHasnamuss() {
        this.strategy = new ThreeBrainStrategy();
        this.setRollMultiple(1);
        this.removeActiveLaw(86);
    }

    public void decays() {
        CBGDlgFactory.giveDecayChoice(this);
    }

    public void giveWildChoice() {
        CBGDlgFactory.giveWildChoice(this);
    }

    public boolean hasNonAceLaw() {
        Iterator it = this.getLawHand().iterator();
        while (it.hasNext()) {
            if (((LawCard)it.next()).getCard().getRank() == 14) continue;
            return true;
        }
        return false;
    }

    public boolean hasNonAceJkrLaw() {
        Iterator it = this.getLawHand().iterator();
        while (it.hasNext()) {
            LawCard lc = (LawCard)it.next();
            if (lc.getCard().getRank() == 14 || lc.getCard().getRank() == 16) continue;
            return true;
        }
        return false;
    }

    public void reincarate() {
        int numBrains;
        int[] rolls = HasnamussStrategy.rollForType();
        if (rolls[0] < 4) {
            this.setRollMultiple(3);
            numBrains = 1;
        } else if (rolls[0] < 6) {
            this.setRollMultiple(2);
            numBrains = 2;
        } else {
            this.setRollMultiple(1);
            numBrains = 3;
        }
        CBGDlgFactory.showReincarnationMessage(numBrains);
        this.initGame();
        this.setType(numBrains);
        this.getFd().clearOctave(1);
        this.getFd().clearOctave(2);
        this.getFd().clearOctave(3);
        this.getFd().give331();
        this.getFd().forceChange();
        this.getEp().clearAllButJoker();
        ConsciousBoardgameGUI.getInstance().showLawsDialog(false);
    }

    public int getRollMultiple() {
        return this.rollMultiple;
    }

    public void setRollMultiple(int rollMultiple) {
        this.rollMultiple = rollMultiple;
    }
}

