/*
 * Decompiled with CFR 0.152.
 */
package cbg.player;

import cbg.boardParts.Board;
import cbg.boardParts.Decks;
import cbg.boardParts.LawCard;
import cbg.common.NoSuchNoteException;
import cbg.common.UIConsts;
import cbg.player.FoodDiagram;
import cbg.player.Player;
import cbg.player.RisingChipModel;
import cbg.ui.CBGDlgFactory;
import cbg.ui.ConsciousBoardgameGUI;
import java.util.Random;
import javax.swing.JOptionPane;

public class LawEnforcer
implements UIConsts {
    public static void enforceLawOnPlayer(LawCard c, Player p, boolean forced) {
        c.setObeyed(true);
        if ((p.hasAccidentMoon() && c.getCard().getSuit() == 4 || p.hasCauseEffectMoon() && c.getCard().getSuit() == 3 || p.hasFateMoon() && c.getCard().getSuit() == 2 || p.hasWillMoon() && c.getCard().getSuit() == 1) && !forced) {
            String msg = "You have a King of";
            switch (c.getCard().getSuit()) {
                case 1: {
                    msg = String.valueOf(msg) + " Spades";
                    break;
                }
                case 2: {
                    msg = String.valueOf(msg) + " Hearts";
                    break;
                }
                case 3: {
                    msg = String.valueOf(msg) + " Clubs";
                    break;
                }
                case 4: {
                    msg = String.valueOf(msg) + " Diamonds";
                }
            }
            CBGDlgFactory.displayMessage(String.valueOf(msg) + " law that frees you\n" + "from the effects of this law.");
            return;
        }
        CBGDlgFactory.displayMessage(c.getLawDesc());
        LawCard lc = null;
        switch (c.getLawValue()) {
            default: {
                System.err.println("Don't know how to obey law card # " + c.getLawValue() + ", the " + c.getCard());
                CBGDlgFactory.displayInformationMessage("Eternal Forgiveness by Ignorance", "Can't obey law card # " + c.getLawValue() + ", the " + c.getCard());
                break;
            }
            case 1: {
                short[] sArray = new short[8];
                sArray[2] = 1;
                p.getFd().enterChips(sArray, null, null);
                break;
            }
            case 2: {
                LawEnforcer.createAllFood(p.getFd());
                break;
            }
            case 3: {
                p.getFd().clear(1, 6);
                break;
            }
            case 4: {
                LawEnforcer.createFirst3Food(p.getFd());
                break;
            }
            case 5: {
                p.getFd().clear(3, 1);
                break;
            }
            case 6: {
                short[] sArray = new short[8];
                sArray[3] = 1;
                short[] sArray2 = new short[6];
                sArray2[1] = 1;
                p.getFd().enterChips(sArray, sArray2, null);
                break;
            }
            case 7: {
                short[] sArray = new short[8];
                sArray[3] = 1;
                sArray[4] = 1;
                p.getFd().enterChips(sArray, null, null);
                break;
            }
            case 8: {
                p.getFd().clear(1, 0);
                break;
            }
            case 9: {
                p.getFd().clear(1, 3);
                p.getFd().clear(1, 4);
                break;
            }
            case 10: {
                short[] sArray = new short[8];
                sArray[0] = 1;
                p.getFd().enterChips(sArray, null, null);
                break;
            }
            case 11: {
                p.getFd().clear(1, 2);
                p.getFd().clear(2, 0);
                break;
            }
            case 12: {
                short[] sArray = new short[8];
                sArray[5] = 1;
                sArray[6] = 1;
                p.getFd().enterChips(sArray, null, null);
                break;
            }
            case 13: {
                short[] sArray = new short[6];
                sArray[5] = 1;
                p.getFd().enterChips(null, sArray, null);
                break;
            }
            case 14: {
                p.getFd().clear(3, 3);
                p.getFd().clearNextImressionAfter6();
                break;
            }
            case 15: {
                short[] sArray = new short[8];
                sArray[7] = 1;
                p.getFd().enterChips(sArray, null, null);
                break;
            }
            case 16: {
                p.getFd().clear(2, 1);
                p.getFd().clear(1, 3);
                break;
            }
            case 17: {
                p.getFd().clearOctave(2);
                break;
            }
            case 18: {
                short[] sArray = new short[8];
                sArray[5] = 1;
                short[] sArray3 = new short[6];
                sArray3[3] = 1;
                short[] sArray4 = new short[4];
                sArray4[1] = 1;
                p.getFd().enterChips(sArray, sArray3, sArray4);
                break;
            }
            case 19: {
                p.setAsleepTil(p.getBoardPos() + 21);
                p.addActiveLaw(c);
                break;
            }
            case 20: {
                short[] sArray = new short[4];
                sArray[1] = 1;
                p.getFd().performShocks(sArray);
                break;
            }
            case 21: {
                p.addActiveLaw(c);
                break;
            }
            case 22: {
                ConsciousBoardgameGUI.instantDeath(p);
                break;
            }
            case 23: {
                int i = 1;
                while (i < p.getType()) {
                    Decks.drawLawCard();
                    ++i;
                }
                lc = Decks.drawLawCard();
                LawEnforcer.enforceLawOnPlayer(lc, p, true);
                ConsciousBoardgameGUI.getInstance().addLawToPlay(lc);
                break;
            }
            case 24: {
                short[] sArray = new short[8];
                sArray[6] = 1;
                short[] sArray5 = new short[6];
                sArray5[4] = 1;
                short[] sArray6 = new short[4];
                sArray6[2] = 1;
                p.getFd().enterChips(sArray, sArray5, sArray6);
                break;
            }
            case 25: {
                LawEnforcer.createAllImpressions(p);
                break;
            }
            case 26: {
                p.getFd().clear(3, 3);
                break;
            }
            case 27: {
                p.giveMCMoment();
                break;
            }
            case 28: {
                p.getFd().clear(2, 0);
                p.getFd().clear(2, 1);
                p.getFd().clear(2, 2);
                break;
            }
            case 29: {
                p.getFd().clear(3, 0);
                break;
            }
            case 30: {
                if (!p.getFd().hasTI12()) {
                    p.getFd().moveNextHighestToTI12();
                }
                p.getFd().transformAll12();
                break;
            }
            case 31: {
                short[] sArray = new short[6];
                sArray[0] = 1;
                p.getFd().enterChips(null, sArray, null);
                break;
            }
            case 32: {
                p.getFd().clear(3, 0);
                p.getFd().clear(2, 0);
                p.getFd().clear(2, 1);
                p.getFd().clear(2, 2);
                p.getFd().clear(1, 0);
                p.getFd().clear(1, 1);
                p.getFd().clear(1, 2);
                break;
            }
            case 33: {
                p.getFd().clear(2, 2);
                break;
            }
            case 34: {
                p.getFd().clear(1, 6);
                p.getFd().clear(1, 5);
                break;
            }
            case 35: {
                short[] sArray = new short[8];
                sArray[4] = 1;
                short[] sArray7 = new short[6];
                sArray7[2] = 1;
                short[] sArray8 = new short[4];
                sArray8[0] = 1;
                p.getFd().enterChips(sArray, sArray7, sArray8);
                break;
            }
            case 36: {
                p.getFd().clear(1, 7);
                p.getFd().clearNextFoodAfter6();
                break;
            }
            case 37: {
                p.getFd().clear(1, 4);
                p.getFd().clear(2, 2);
                p.getFd().clear(3, 0);
                break;
            }
            case 38: {
                LawEnforcer.createAll6(p);
                break;
            }
            case 39: {
                RisingChipModel rcm = new RisingChipModel();
                p.getFd().shocksFood(rcm);
                p.getFd().enterChips(rcm);
                break;
            }
            case 40: {
                p.getFd().clear(3, 3);
                p.getFd().clear(3, 2);
                p.getFd().clear(3, 1);
                p.getFd().clear(3, 0);
                break;
            }
            case 41: {
                if (Board.getNumSpaces() <= p.getBoardPos() + 37) {
                    p.setNoSkillsTil(Board.getNumSpaces() - 1);
                } else {
                    p.setNoSkillsTil(p.getBoardPos() + 37);
                }
                p.addActiveLaw(c);
                break;
            }
            case 42: {
                short[] sArray = new short[4];
                sArray[0] = 1;
                p.getFd().performShocks(sArray);
                break;
            }
            case 43: {
                p.addActiveLaw(c);
                break;
            }
            case 44: {
                p.addActiveLaw(c);
                JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), "Death comes in 41 spaces.", "Cancer", 2);
                if (p.getBoardPos() + 41 >= p.getDeathSpace()) break;
                p.setDeathSpace(p.getBoardPos() + 41);
                break;
            }
            case 45: {
                p.getFd().clear(1, 7);
                break;
            }
            case 46: {
                p.getFd().clear(2, 0);
                break;
            }
            case 47: {
                p.drawPOCCard(true);
                break;
            }
            case 48: {
                p.getFd().clear(2, 5);
                break;
            }
            case 49: {
                p.getFd().clear(3, 2);
                p.getFd().clear(3, 1);
                break;
            }
            case 50: {
                if (p.getLawHand().size() > 0) {
                    ConsciousBoardgameGUI.getInstance().showLawsDialog(true);
                    break;
                }
                JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), "There were no law cards in your law hand.\nYou get no law by choice.", "No Law Cards", 1);
                break;
            }
            case 51: {
                short[] sArray = new short[6];
                sArray[3] = 1;
                sArray[4] = 1;
                p.getFd().enterChips(null, sArray, null);
                break;
            }
            case 52: {
                p.getFd().clear(1, 2);
                break;
            }
            case 53: {
                p.drawLawCard();
                p.drawLawCard();
                p.drawLawCard();
                break;
            }
            case 54: {
                int i = 0;
                while (i < 5) {
                    p.drawPOCCard(true);
                    ++i;
                }
                break;
            }
            case 55: {
                p.getFd().shockAllMI48();
                break;
            }
            case 56: {
                p.getFd().clear(3, 2);
                p.getFd().clear(2, 4);
                p.getFd().clear(1, 6);
                break;
            }
            case 57: {
                short[] sArray = new short[8];
                sArray[2] = 1;
                short[] sArray9 = new short[6];
                sArray9[0] = 1;
                p.getFd().enterChips(sArray, sArray9, null);
                break;
            }
            case 58: {
                p.getFd().clearOctave(1);
                break;
            }
            case 59: {
                p.setNoPowersTil(p.getBoardPos() + 33);
                p.addActiveLaw(c);
                ConsciousBoardgameGUI.getInstance().disablePowerButtons();
                break;
            }
            case 60: {
                p.setOppositeRoll(true);
                break;
            }
            case 61: {
                p.addActiveLaw(c);
                break;
            }
            case 62: {
                p.addActiveLaw(c);
                JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), "Death comes in 27 spaces.", "Family Disease", 2);
                if (p.getBoardPos() + 27 >= p.getDeathSpace()) break;
                p.setDeathSpace(p.getBoardPos() + 27);
                break;
            }
            case 63: {
                break;
            }
            case 64: {
                lc = Decks.drawLawCard();
                LawEnforcer.enforceLawOnPlayer(lc, p, true);
                ConsciousBoardgameGUI.getInstance().addLawToPlay(lc);
                break;
            }
            case 65: {
                short[] sArray = new short[4];
                sArray[0] = 1;
                p.getFd().enterChips(null, null, sArray);
                break;
            }
            case 66: {
                try {
                    if (p.getFd().takeChip(3, 0)) {
                        p.getFd().clear(3, 0);
                        break;
                    }
                    if (p.getFd().takeChip(3, 1)) break;
                    if (p.getFd().takeChip(3, 2)) {
                        p.getFd().clear(3, 2);
                        break;
                    }
                    p.getFd().clear(3, 3);
                }
                catch (NoSuchNoteException e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace(System.err);
                }
                break;
            }
            case 67: {
                p.getFd().moveMI192toTI12();
                break;
            }
            case 68: {
                p.getFd().clear(1, 0);
                p.getFd().clear(1, 1);
                p.getFd().clear(1, 2);
                break;
            }
            case 69: {
                short[] sArray = new short[4];
                sArray[1] = 1;
                p.getFd().enterChips(null, null, sArray);
                break;
            }
            case 70: {
                p.getFd().clear(1, 5);
                p.getFd().clear(2, 3);
                p.getFd().clear(3, 1);
                break;
            }
            case 71: {
                p.getFd().clear(2, 3);
                p.getFd().clear(2, 4);
                break;
            }
            case 72: {
                p.setLawPlaysThis(1);
                ConsciousBoardgameGUI.getInstance().showLawsDialog(false);
                break;
            }
            case 73: {
                short[] sArray = new short[4];
                sArray[2] = 1;
                p.getFd().enterChips(null, null, sArray);
                break;
            }
            case 74: {
                p.getFd().clear(3, 2);
                break;
            }
            case 75: {
                p.getLawHand().clear();
                break;
            }
            case 76: {
                p.getFd().clear(2, 5);
                try {
                    if (p.getFd().takeChip(2, 4) || p.getFd().takeChip(2, 3)) break;
                    if (p.getFd().takeChip(2, 2)) {
                        p.getFd().clear(2, 2);
                        break;
                    }
                    if (p.getFd().takeChip(2, 1)) break;
                    p.getFd().takeChip(2, 0);
                }
                catch (NoSuchNoteException e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace(System.err);
                }
                break;
            }
            case 77: {
                short[] sArray = new short[4];
                sArray[3] = 1;
                p.getFd().enterChips(null, null, sArray);
                break;
            }
            case 78: {
                Random rand = new Random(System.currentTimeMillis());
                int index = rand.nextInt(p.getPocHand().size());
                p.getPocHand().remove(index);
                break;
            }
            case 79: {
                p.setRollAgain(true);
                break;
            }
            case 80: {
                int half = p.getPocHand().size() / 2;
                Random r1 = new Random(System.currentTimeMillis());
                int i = 0;
                while (i < half) {
                    p.getPocHand().remove(r1.nextInt(p.getPocHand().size()));
                    ++i;
                }
                break;
            }
            case 81: {
                p.getFd().clear(1, 7);
                p.getFd().clear(2, 5);
                p.getFd().clear(3, 3);
                break;
            }
            case 82: {
                short[] sArray = new short[4];
                sArray[3] = 1;
                p.getFd().performShocks(sArray);
                break;
            }
            case 83: {
                p.addActiveLaw(c);
                break;
            }
            case 84: {
                ConsciousBoardgameGUI.instantDeath(p);
                break;
            }
            case 85: {
                CBGDlgFactory.displayMessage("Any other laws not yet obeyed are now cancelled.");
                int i = 0;
                while (i < p.getLawsInPlay().size()) {
                    ((LawCard)p.getLawsInPlay().get(i)).setObeyed(true);
                    ++i;
                }
                p.removeAllLawsButJoker();
                if (!p.isHasnamuss()) break;
                p.cleanseHasnamuss();
                break;
            }
            case 86: {
                p.makeHasnamuss();
                p.addActiveLaw(c);
            }
        }
        p.getFd().checkComplete();
        p.getFd().forceChange();
    }

    private static void createAll6(Player p) {
        short[] sArray = new short[8];
        sArray[7] = 1;
        short[] sArray2 = new short[6];
        sArray2[5] = 1;
        short[] sArray3 = new short[4];
        sArray3[3] = 1;
        p.getFd().enterChips(sArray, sArray2, sArray3);
    }

    private static void createAllImpressions(Player p) {
        p.getFd().enterChips(null, null, new short[]{1, 1, 1, 1});
    }

    private static void createFirst3Food(FoodDiagram fd) {
        short[] sArray = new short[8];
        sArray[0] = 1;
        sArray[1] = 1;
        sArray[2] = 1;
        fd.enterChips(sArray, null, null);
    }

    private static void createAllFood(FoodDiagram fd) {
        fd.enterChips(new short[]{1, 1, 1, 1, 1, 1, 1, 1}, null, null);
    }
}

