/*
 * Decompiled with CFR 0.152.
 */
package cbg.player;

import cbg.boardParts.Board;
import cbg.boardParts.Dice;
import cbg.boardParts.LawCard;
import cbg.player.Player;
import cbg.player.PlayerStrategy;
import cbg.ui.CBGDlgFactory;
import cbg.ui.ConsciousBoardgameGUI;
import javax.swing.JOptionPane;

public class HasnamussStrategy
extends PlayerStrategy {
    public static final short NOT_DEAD = 0;
    public static final short ASTRAL_DEAD = 1;
    public static final short CAUSAL_DEAD = 2;
    private String planetName = "";
    private short deathScenario = 0;

    public boolean survivesDeath(Player thePlayer) {
        if (this.deathScenario == 0) {
            return thePlayer.getFd().hasChrystallizedAstral();
        }
        return true;
    }

    public void dies(Player thePlayer) {
        switch (this.deathScenario) {
            case 0: {
                if (this.survivesDeath(thePlayer)) {
                    if (thePlayer.getFd().hasChrystallizedMental()) {
                        JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), "You died as a Hasnamuss with a Causal (Mental) body.\nAt the end of this turn, you will move to the Planet of your Hasnamuss.", "Mental Death", -1);
                        break;
                    }
                    JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), "You died as a Hasnamuss with an Astral body.\nIn order to escape the endless cycle of reincarnation,\nyou must complete your Mental body before the end of this turn.\nNOTE: Astral Hasnamuss discards all pieces of\n\tEssence and Personality except the Joker.", "Astral Death", -1);
                    break;
                }
                JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), "You just died. As a Hasnamuss with no higher body chrystallized,\nyou have until the end of this turn to complete an Astral body -\nOr your game will be over.\n", "Simple Death", 2);
                break;
            }
            case 1: {
                if (thePlayer.getRollMultiple() == 1 && thePlayer.getFd().hasChrystallizedMental()) {
                    JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), "Sorry you just died. As a three brained Hasnamuss with a Mental body,\nyou will move to the Planet of your Hasnamuss at the end of this turn.", "Mental Death", -1);
                    break;
                }
                JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), "You died as a " + (thePlayer.getRollMultiple() == 2 ? 2 : 1) + "-brained Hasnamuss.\n" + "You will reincarnate at the end of this turn, losing your cards\n" + "and all Essence and Personality pieces except the Joker.", "Astral Death", -1);
                break;
            }
            case 2: {
                JOptionPane.showMessageDialog(ConsciousBoardgameGUI.getInstance(), "You died as a Hasnamuss with a Causal (Mental) body.\nAt the end of this turn, you will move to the Planet of your Hasnamuss.", "Mental Death", -1);
            }
        }
    }

    public void startDeath(Player thePlayer) {
        System.out.println("Hasnamuss::startDeath() start: " + this.toString());
        if (!thePlayer.getActiveLaws().contains(LawCard.Joker)) {
            thePlayer.addActiveLaw(LawCard.Joker);
        }
        if (this.deathScenario == 0) {
            if (thePlayer.getFd().hasChrystallizedMental()) {
                this.deathScenario = (short)2;
                this.startCausalDeath(thePlayer);
            } else if (thePlayer.getFd().hasChrystallizedAstral()) {
                this.deathScenario = 1;
                this.startAstralDeath(thePlayer);
            }
        } else if (this.deathScenario == 1) {
            this.startAstralDeath(thePlayer);
        } else if (this.deathScenario == 2) {
            this.startCausalDeath(thePlayer);
        }
        System.out.println("Hasnamuss::startDeath() end: " + this.toString());
    }

    private void startAstralDeath(Player thePlayer) {
        System.out.println("start Astral Muss Death for " + thePlayer.getName());
        if (thePlayer.getRollMultiple() == 1 && thePlayer.getFd().hasChrystallizedMental()) {
            System.out.println("Player has 3 brains and a Mental body, i.e. Causal Hasnamuss");
            this.deathScenario = (short)2;
            this.startCausalDeath(thePlayer);
            return;
        }
        thePlayer.reincarate();
    }

    private void startCausalDeath(Player thePlayer) {
        thePlayer.isDead = true;
        System.out.println("startCausalDeath for " + thePlayer.getName());
        int[] rolls = HasnamussStrategy.rollForType();
        if (rolls[0] < 4) {
            if (rolls[0] == rolls[1]) {
                CBGDlgFactory.displayInformationMessage("Redemption", "You're quite fortunate. When rolling to determine the Planet of your Hasnamuss,\nyou rolled " + rolls[1] + " twice in a row and are automatically cleansed.");
                thePlayer.cleanseHasnamuss();
                return;
            }
            this.planetName = "Remorse of Conscience";
            thePlayer.setRollMultiple(1);
        } else if (rolls[0] > 5) {
            if (rolls[0] == rolls[1]) {
                CBGDlgFactory.endGameMessage("You are very unfortunate. When rolling to determine the Planet of your Hasnamuss,\nyou rolled " + rolls[1] + " twice in a row. The Planet of your Hasnamuss is Eternal Retribution.\n" + "There is no escape from this loathesome place; you are out of the game backwards.\n" + "You must have done something very bad indeed. Want to try again?");
                return;
            }
            this.planetName = "Self Reproach";
            thePlayer.setRollMultiple(3);
        } else if (rolls[0] == rolls[1]) {
            this.planetName = "Remorse of Conscience";
            thePlayer.setRollMultiple(1);
        } else {
            this.planetName = "Repentance";
            thePlayer.setRollMultiple(2);
        }
        CBGDlgFactory.showCausalDeathMessage(thePlayer, this.planetName);
        Board.initDeathBoard();
        thePlayer.getFd().shiftAfterDeath();
        if (thePlayer.firstDeath) {
            if (thePlayer.getPocHand().size() > 7) {
                ConsciousBoardgameGUI.getInstance().keepSelectedCardsConfig();
            } else if (thePlayer.getPocHand().size() < 7) {
                int added = 7 - thePlayer.getPocHand().size();
                int i = 0;
                while (i < added) {
                    thePlayer.drawPOCCard(true);
                    ++i;
                }
                CBGDlgFactory.displayInformationMessage("Draw up to 7", "You drew " + added + " cards to start death.\n");
            }
            thePlayer.firstDeath = false;
        }
    }

    public static int[] rollForType() {
        Dice.setNumSides(6);
        Dice.setHasZero(false);
        int[] rolls = new int[]{Dice.roll(), Dice.roll()};
        Dice.init();
        System.out.println("Hasnamuss type rolls: " + rolls[0] + ", " + rolls[1]);
        return rolls;
    }

    public boolean isHasnamuss() {
        return true;
    }

    public String getPlanetName() {
        return this.planetName;
    }

    public String toString() {
        return "deathScenario=" + this.deathScenario + ", planetName=" + this.planetName;
    }
}

