/*
 * Decompiled with CFR 0.152.
 */
package cbg.player;

import cbg.common.NoSuchNoteException;
import cbg.common.UIConsts;
import cbg.player.Player;
import cbg.player.RisingChipModel;
import cbg.ui.CBGDlgFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;

public class FoodDiagram
implements UIConsts {
    private static final int PHYSICAL = 0;
    private Player player;
    private int foodAstral;
    private int airAstral;
    private int impAstral;
    private int foodMental;
    private int airMental;
    private int impMental;
    private int currentBody;
    private boolean hasChrystallizedAstral;
    private boolean hasChrystallizedMental;
    private boolean hasMovedMental;
    private boolean isComplete;
    private Note[] foodOctave = new Note[8];
    private Note[] airOctave = new Note[6];
    private Note[] impOctave = new Note[4];
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    public FoodDiagram(Player p) {
        this.player = p;
        this.currentBody = 0;
        this.foodOctave[0] = new Note(1);
        this.foodOctave[1] = new Note(1);
        this.foodOctave[2] = new Note(3);
        this.foodOctave[3] = new Note(1);
        this.foodOctave[4] = new Note(1);
        this.foodOctave[5] = new Note(1);
        this.foodOctave[6] = new Note(3);
        this.foodOctave[7] = new Note(1);
        this.airOctave[0] = new Note(1);
        this.airOctave[1] = new Note(1);
        this.airOctave[2] = new Note(3);
        this.airOctave[3] = new Note(1);
        this.airOctave[4] = new Note(1);
        this.airOctave[5] = new Note(1);
        this.impOctave[0] = new Note(3);
        this.impOctave[1] = new Note(1);
        this.impOctave[2] = new Note(3);
        this.impOctave[3] = new Note(1);
        this.give331();
    }

    public void give331() {
        this.foodOctave[0].addChip();
        this.foodOctave[1].addChip();
        this.foodOctave[2].addChip();
        this.airOctave[0].addChip();
        this.airOctave[1].addChip();
        this.airOctave[2].addChip();
        this.impOctave[0].addChip();
    }

    public boolean has192() {
        return this.foodOctave[2].hasChip() || this.airOctave[0].hasChip();
    }

    public boolean has96() {
        return this.foodOctave[3].hasChip() || this.airOctave[1].hasChip();
    }

    public boolean has48() {
        return this.impOctave[0].hasChip() || this.airOctave[2].hasChip() || this.foodOctave[4].hasChip();
    }

    public boolean has24() {
        return this.impOctave[1].hasChip() || this.airOctave[3].hasChip() || this.foodOctave[5].hasChip();
    }

    public boolean has12() {
        return this.impOctave[2].hasChip() || this.airOctave[4].hasChip() || this.foodOctave[6].hasChip();
    }

    public boolean has6() {
        return this.foodOctave[7].hasChip() || this.airOctave[5].hasChip() || this.impOctave[3].hasChip();
    }

    public boolean hasTI12() {
        return this.foodOctave[6].hasChip();
    }

    public boolean hasMI48() {
        return this.airOctave[2].hasChip();
    }

    public boolean hasMI192() {
        return this.foodOctave[2].hasChip();
    }

    public void eat() {
        short[] sArray = new short[8];
        sArray[0] = 1;
        this.enterChips(sArray, null, null);
    }

    public void breathe() {
        short[] sArray = new short[6];
        sArray[0] = 1;
        this.enterChips(null, sArray, null);
    }

    public void impression() {
        short[] sArray = new short[4];
        sArray[0] = 1;
        this.enterChips(null, null, sArray);
    }

    public void performShocks(short[] shocks) {
        RisingChipModel rcm = new RisingChipModel();
        short i = 0;
        i = 0;
        while (i < shocks[3]) {
            this.allShocks(rcm);
            i = (short)(i + 1);
        }
        i = 0;
        while (i < shocks[2]) {
            String choice = null;
            while (choice == null) {
                choice = CBGDlgFactory.giveShockChoice();
            }
            System.out.println("You chose " + choice + " for your wild shock.");
            if (choice.equals(Shocks[0])) {
                this.shocksFood(rcm);
            } else if (choice.equals(Shocks[1])) {
                this.selfRemember(rcm);
            } else if (choice.equals(Shocks[2])) {
                this.transformEmotions(rcm);
            } else {
                System.err.println("You chose an invalid shock " + choice);
            }
            i = (short)(i + 1);
        }
        i = 0;
        while (i < shocks[1]) {
            this.transformEmotions(rcm);
            i = (short)(i + 1);
        }
        i = 0;
        while (i < shocks[0]) {
            this.selfRemember(rcm);
            i = (short)(i + 1);
        }
        this.enterChips(rcm);
        this.checkComplete();
    }

    public void shocksFood(RisingChipModel rcm) {
        if (this.foodOctave[2].hasChip()) {
            this.foodOctave[2].takeChip();
            rcm.add((short)1, (short)3);
        }
    }

    public void selfRemember(RisingChipModel rcm) {
        if (this.impOctave[0].hasChip()) {
            this.impOctave[0].takeChip();
            rcm.add((short)3, (short)1);
        }
    }

    public void transformEmotions(RisingChipModel rcm) {
        if (this.foodOctave[6].hasChip()) {
            this.foodOctave[6].takeChip();
            rcm.add((short)1, (short)7);
        }
        if (this.impOctave[2].hasChip()) {
            this.impOctave[2].takeChip();
            rcm.add((short)3, (short)3);
        }
    }

    public void allShocks(RisingChipModel rcm) {
        if (this.foodOctave[2].hasChip()) {
            this.foodOctave[2].takeChip();
            rcm.add((short)1, (short)3);
        }
        if (this.foodOctave[6].hasChip()) {
            this.foodOctave[6].takeChip();
            rcm.add((short)1, (short)7);
        }
        if (this.impOctave[2].hasChip()) {
            this.impOctave[2].takeChip();
            rcm.add((short)3, (short)3);
        }
        if (this.impOctave[0].hasChip()) {
            this.impOctave[0].takeChip();
            rcm.add((short)3, (short)1);
        }
    }

    public void enterChips(short[] f, short[] a, short[] i) {
        RisingChipModel rcm = new RisingChipModel(f, a, i);
        this.enterChips(rcm);
    }

    public void enterChips(RisingChipModel rcm) {
        if (rcm.get((short)1, (short)1) > 0) {
            this.foodOctave[1].addChip();
            rcm.set((short)1, (short)1, (short)0);
        }
        if (rcm.get((short)1, (short)4) > 0) {
            this.foodOctave[4].addChip();
            rcm.set((short)1, (short)4, (short)0);
        }
        if (rcm.get((short)1, (short)5) > 0) {
            this.foodOctave[5].addChip();
            rcm.set((short)1, (short)5, (short)0);
        }
        if (rcm.get((short)2, (short)4) > 0) {
            this.airOctave[4].addChip();
            rcm.set((short)2, (short)4, (short)0);
        }
        if (rcm.get((short)3, (short)1) > 0) {
            short mi48 = rcm.get((short)2, (short)2);
            if (mi48 > 0 && !this.airOctave[2].hasChip()) {
                this.airOctave[2].addChip();
                rcm.set((short)2, (short)2, (short)(mi48 - 1));
            }
            if (this.airOctave[2].takeChip()) {
                rcm.add((short)2, (short)3);
            }
        }
        if (rcm.get((short)2, (short)1) > 0) {
            short mi192 = rcm.get((short)1, (short)2);
            if (mi192 > 0 && !this.foodOctave[2].hasChip()) {
                this.foodOctave[2].addChip();
                rcm.set((short)1, (short)2, (short)(mi192 - 1));
            }
            if (this.foodOctave[2].takeChip()) {
                rcm.add((short)1, (short)3);
            }
            this.airOctave[1].addChip();
            rcm.set((short)2, (short)1, (short)0);
        }
        rcm.process(this);
        this.forceChange();
    }

    void handleNewPieces(RisingChipModel rcm) {
        System.out.print("handleNewPieces ");
        short[] food = new short[8];
        short[] air = new short[6];
        int extraFood = 0;
        int extraAir = 0;
        int extraImp = 0;
        if (!this.hasChrystallizedAstral) {
            int n;
            int i;
            this.foodAstral += rcm.excessFood();
            this.airAstral += rcm.excessAir();
            this.impAstral += rcm.excessImp();
            System.out.println("adding to astral accum: f=" + this.foodAstral + ", a=" + this.airAstral + ", i=" + this.impAstral);
            if (this.airAstral >= 3 && this.foodAstral >= 3 && this.impAstral >= 1) {
                this.hasChrystallizedAstral = true;
                CBGDlgFactory.displayMessage("You have chrystallized the body Kesdjan!");
                this.changes.firePropertyChange("NewBody", null, "Astral Body");
                this.moveAstral();
                return;
            }
            if (this.foodAstral > 3) {
                int drawCards = this.foodAstral - 3;
                this.foodAstral = 3;
                CBGDlgFactory.displayMessage("You drew " + drawCards + " card for extra astral food.");
                int i2 = 0;
                while (i2 < drawCards) {
                    this.player.drawPOCCard(true);
                    ++i2;
                }
            }
            if (this.airAstral > 3) {
                extraAir = this.airAstral - 3;
                this.airAstral = 3;
                i = 0;
                while (i < extraAir) {
                    n = CBGDlgFactory.giveAirChoice();
                    if (n == 0) {
                        food[0] = (short)(food[0] + 1);
                    } else {
                        this.player.drawPOCCard(true);
                    }
                    ++i;
                }
            }
            if (this.impAstral > 1) {
                extraImp = this.impAstral - 1;
                this.impAstral = 1;
                i = 0;
                while (i < extraImp) {
                    n = CBGDlgFactory.giveImpChoice();
                    if (n == 0) {
                        air[0] = (short)(air[0] + 1);
                    } else {
                        this.player.drawPOCCard(true);
                    }
                    ++i;
                }
            }
            this.enterChips(food, air, null);
            return;
        }
        if (!this.hasChrystallizedMental) {
            int n;
            int i;
            if (this.currentBody == 0) {
                this.foodAstral += rcm.excessFood();
                if (this.foodAstral > 8) {
                    this.foodMental += this.foodAstral - 8;
                    this.foodAstral = 8;
                }
                this.airAstral += rcm.excessAir();
                if (this.airAstral > 6) {
                    this.airMental += this.airAstral - 6;
                    this.airAstral = 6;
                }
                this.impAstral += rcm.excessImp();
                if (this.impAstral > 4) {
                    this.impMental += this.impAstral - 4;
                    this.impAstral = 4;
                }
            } else {
                this.foodMental += rcm.excessFood();
                this.airMental += rcm.excessAir();
                this.impMental += rcm.excessImp();
                if (this.currentBody != 2) {
                    System.err.println("astral body? currentBody==" + this.currentBody);
                }
            }
            System.out.println("adding to mental accum: f=" + this.foodMental + ", a=" + this.airMental + ", i=" + this.impMental);
            if (this.airMental >= 3 && this.foodMental >= 3 && this.impMental >= 1) {
                this.hasChrystallizedMental = true;
                System.out.println("You have chrystallized the mental body!");
                this.changes.firePropertyChange("NewBody", null, "Mental Body");
                if (this.player.isDead()) {
                    CBGDlgFactory.displayMessage("You chrystallized your Mental Body after death.\nYou may discard the astral body for the mental anytime\nbefore the end of this turn.");
                    this.changes.firePropertyChange("DiscardAstral", null, null);
                } else {
                    CBGDlgFactory.displayMessage("You have chrystallized your Mental Body.");
                    this.moveMental();
                }
                return;
            }
            if (this.foodMental > 3) {
                extraFood = this.foodMental - 3;
                this.foodMental = 3;
                i = 0;
                while (i < extraFood) {
                    this.player.drawPOCCard(true);
                    ++i;
                }
                CBGDlgFactory.displayMessage("You drew " + extraFood + " cards for excess food stuff.");
            }
            if (this.airMental > 3) {
                extraAir = this.airMental - 3;
                this.airMental = 3;
                i = 0;
                while (i < extraAir) {
                    n = CBGDlgFactory.giveAirChoice();
                    if (n == 0) {
                        food[0] = (short)(food[0] + 1);
                    } else {
                        this.player.drawPOCCard(true);
                    }
                    ++i;
                }
            }
            if (this.impMental > 1) {
                extraImp = this.impMental - 1;
                this.impMental = 1;
                i = 0;
                while (i < extraImp) {
                    n = CBGDlgFactory.giveImpChoice();
                    if (n == 0) {
                        air[0] = (short)(air[0] + 1);
                    } else {
                        this.player.drawPOCCard(true);
                    }
                    ++i;
                }
            }
            this.enterChips(food, air, null);
            return;
        }
        if (this.currentBody != 4) {
            int n;
            int i;
            this.foodMental += rcm.excessFood();
            this.airMental += rcm.excessAir();
            this.impMental += rcm.excessImp();
            if (this.foodMental > 8) {
                extraFood = this.foodMental - 8;
                this.foodMental = 8;
                i = 0;
                while (i < extraFood) {
                    this.player.drawPOCCard(true);
                    ++i;
                }
                CBGDlgFactory.displayMessage("You drew " + extraFood + " cards for excess food stuff.");
            }
            if (this.airMental > 6) {
                extraAir = this.airMental - 6;
                this.airMental = 6;
                i = 0;
                while (i < extraAir) {
                    n = CBGDlgFactory.giveAirChoice();
                    if (n == 0) {
                        food[0] = (short)(food[0] + 1);
                    } else {
                        this.player.drawPOCCard(true);
                    }
                    ++i;
                }
            }
            if (this.impMental > 4) {
                extraImp = this.impMental - 4;
                this.impMental = 4;
                i = 0;
                while (i < extraImp) {
                    n = CBGDlgFactory.giveImpChoice();
                    if (n == 0) {
                        air[0] = (short)(air[0] + 1);
                    } else {
                        this.player.drawPOCCard(true);
                    }
                    ++i;
                }
            }
        } else {
            int n;
            int i;
            extraAir += rcm.excessAir();
            extraImp += rcm.excessImp();
            if ((extraFood += rcm.excessFood()) > 0) {
                i = 0;
                while (i < extraFood) {
                    this.player.drawPOCCard(true);
                    ++i;
                }
                CBGDlgFactory.displayMessage("You drew " + extraFood + " cards for excess food stuff.");
            }
            if (extraAir > 0) {
                i = 0;
                while (i < extraAir) {
                    n = CBGDlgFactory.giveAirChoice();
                    if (n == 0) {
                        food[0] = (short)(food[0] + 1);
                    } else {
                        this.player.drawPOCCard(true);
                    }
                    ++i;
                }
            }
            if (extraImp > 4) {
                i = 0;
                while (i < extraImp) {
                    n = CBGDlgFactory.giveImpChoice();
                    if (n == 0) {
                        air[0] = (short)(air[0] + 1);
                    } else {
                        this.player.drawPOCCard(true);
                    }
                    ++i;
                }
            }
        }
        this.enterChips(food, air, null);
    }

    public void shiftAfterDeath() {
        System.out.println("FD.shiftAfterDeath:");
        if (this.hasChrystallizedMental && this.currentBody != 4) {
            System.out.println("moving mental");
            int i = 0;
            while (i < this.foodOctave.length) {
                this.foodOctave[i].setChips(0);
                this.foodOctave[i].setHasAstral(false);
                this.foodOctave[i].setHasMental(false);
                ++i;
            }
            i = 0;
            while (i < this.airOctave.length) {
                this.airOctave[i].setChips(0);
                this.airOctave[i].setHasAstral(false);
                this.airOctave[i].setHasMental(false);
                ++i;
            }
            i = 0;
            while (i < this.impOctave.length) {
                this.impOctave[i].setChips(0);
                this.impOctave[i].setHasAstral(false);
                this.impOctave[i].setHasMental(false);
                ++i;
            }
            i = 0;
            while (i < this.foodMental) {
                this.foodOctave[i].setChips(1);
                ++i;
            }
            i = 0;
            while (i < this.airMental) {
                this.airOctave[i].setChips(1);
                ++i;
            }
            i = 0;
            while (i < this.impMental) {
                this.impOctave[i].setChips(1);
                ++i;
            }
            this.hasMovedMental = true;
            this.currentBody = 4;
        } else if (this.hasChrystallizedAstral && this.currentBody == 0) {
            System.out.println("moving astral");
            int i = 0;
            while (i < this.foodOctave.length) {
                this.foodOctave[i].setChips(0);
                this.foodOctave[i].setHasAstral(false);
                this.foodOctave[i].setHasMental(false);
                ++i;
            }
            i = 0;
            while (i < this.airOctave.length) {
                this.airOctave[i].setChips(0);
                this.airOctave[i].setHasAstral(false);
                this.airOctave[i].setHasMental(false);
                ++i;
            }
            i = 0;
            while (i < this.impOctave.length) {
                this.impOctave[i].setChips(0);
                this.impOctave[i].setHasAstral(false);
                this.impOctave[i].setHasMental(false);
                ++i;
            }
            i = 0;
            while (i < this.foodAstral) {
                this.foodOctave[i].setChips(1);
                ++i;
            }
            i = 0;
            while (i < this.airAstral) {
                this.airOctave[i].setChips(1);
                ++i;
            }
            i = 0;
            while (i < this.impAstral) {
                this.impOctave[i].setChips(1);
                ++i;
            }
            this.currentBody = 2;
        }
        this.forceChange();
    }

    public void clear(int type, int noteNumber) {
        if (type == 1) {
            this.foodOctave[noteNumber].clearChips();
        } else if (type == 2) {
            this.airOctave[noteNumber].clearChips();
        } else if (type == 3) {
            this.impOctave[noteNumber].clearChips();
        }
    }

    public boolean takeChip(int octave, int noteNumber) throws NoSuchNoteException {
        if (octave == 1) {
            return this.foodOctave[noteNumber].takeChip();
        }
        if (octave == 2) {
            return this.airOctave[noteNumber].takeChip();
        }
        if (octave == 3) {
            return this.impOctave[noteNumber].takeChip();
        }
        throw new NoSuchNoteException("Octave " + octave + " / Note #" + noteNumber + " not valid.");
    }

    public boolean putChip(int octave, int noteNumber) throws NoSuchNoteException {
        if (octave == 1) {
            return this.foodOctave[noteNumber].addChip();
        }
        if (octave == 2) {
            return this.airOctave[noteNumber].addChip();
        }
        if (octave == 3) {
            return this.impOctave[noteNumber].addChip();
        }
        throw new NoSuchNoteException("Octave " + octave + " / Note #" + noteNumber + " not valid.");
    }

    public void clearOctave(int type) {
        block4: {
            block5: {
                block3: {
                    if (type != 1) break block3;
                    int i = 0;
                    while (i < this.foodOctave.length) {
                        this.foodOctave[i].clearChips();
                        ++i;
                    }
                    break block4;
                }
                if (type != 2) break block5;
                int i = 0;
                while (i < this.airOctave.length) {
                    this.airOctave[i].clearChips();
                    ++i;
                }
                break block4;
            }
            if (type != 3) break block4;
            int i = 0;
            while (i < this.impOctave.length) {
                this.impOctave[i].clearChips();
                ++i;
            }
        }
    }

    public void clearNextImressionAfter6() {
        if (this.impOctave[2].hasChip()) {
            this.impOctave[2].clearChips();
        } else if (this.impOctave[1].hasChip()) {
            this.impOctave[1].clearChips();
        } else if (this.impOctave[0].hasChip()) {
            this.impOctave[0].clearChips();
        }
    }

    public void clearNextFoodAfter6() {
        if (this.foodOctave[6].hasChip()) {
            this.foodOctave[6].clearChips();
        } else if (this.foodOctave[5].hasChip()) {
            this.foodOctave[5].clearChips();
        } else if (this.foodOctave[4].hasChip()) {
            this.foodOctave[4].clearChips();
        } else if (this.foodOctave[3].hasChip()) {
            this.foodOctave[3].clearChips();
        } else if (this.foodOctave[2].hasChip()) {
            this.foodOctave[2].clearChips();
        } else if (this.foodOctave[1].hasChip()) {
            this.foodOctave[1].clearChips();
        } else if (this.foodOctave[0].hasChip()) {
            this.foodOctave[0].clearChips();
        }
    }

    public byte[] getCurrentState() {
        byte[] status = new byte[18];
        int i = 0;
        while (i < this.foodOctave.length) {
            status[i] = this.foodOctave[i].getState();
            ++i;
        }
        i = 0;
        while (i < this.airOctave.length) {
            status[i + 8] = this.airOctave[i].getState();
            ++i;
        }
        i = 0;
        while (i < this.impOctave.length) {
            status[i + 14] = this.impOctave[i].getState();
            ++i;
        }
        return status;
    }

    public byte[] getAccrualStates() {
        byte[] accrues = new byte[]{(byte)(this.foodOctave[2].getChips() - 1 < 0 ? 0 : this.foodOctave[2].getChips() - 1), (byte)(this.airOctave[2].getChips() - 1 < 0 ? 0 : this.airOctave[2].getChips() - 1), (byte)(this.impOctave[0].getChips() - 1 < 0 ? 0 : this.impOctave[0].getChips() - 1), (byte)(this.foodOctave[6].getChips() - 1 < 0 ? 0 : this.foodOctave[6].getChips() - 1), (byte)(this.impOctave[2].getChips() - 1 < 0 ? 0 : this.impOctave[2].getChips() - 1)};
        return accrues;
    }

    public byte[] getAccumStates() {
        byte[] accums;
        block7: {
            block6: {
                accums = new byte[15];
                if (this.hasChrystallizedAstral) break block6;
                int i = 0;
                while (i < this.foodAstral) {
                    accums[i] = 2;
                    ++i;
                }
                i = 0;
                while (i < this.airAstral) {
                    accums[5 + i] = 2;
                    ++i;
                }
                i = 0;
                while (i < this.impAstral) {
                    accums[11 + i] = 2;
                    ++i;
                }
                break block7;
            }
            if (this.hasChrystallizedMental && this.hasMovedMental) break block7;
            int i = 0;
            while (i < this.foodMental) {
                accums[i] = 4;
                ++i;
            }
            i = 0;
            while (i < this.airMental) {
                accums[5 + i] = 4;
                ++i;
            }
            i = 0;
            while (i < this.impMental) {
                accums[11 + i] = 4;
                ++i;
            }
        }
        return accums;
    }

    public String toString() {
        StringBuffer fdbuf = new StringBuffer("Food : DO768(" + this.foodOctave[0].getChips() + ")");
        fdbuf.append(" RE384(" + this.foodOctave[1].getChips() + ")");
        fdbuf.append(" MI192(" + this.foodOctave[2].getChips() + ")");
        fdbuf.append(" FA96(" + this.foodOctave[3].getChips() + ")");
        fdbuf.append(" SO48(" + this.foodOctave[4].getChips() + ")");
        fdbuf.append(" LA24(" + this.foodOctave[5].getChips() + ")");
        fdbuf.append(" TI12(" + this.foodOctave[6].getChips() + ")");
        fdbuf.append(" DO6(" + this.foodOctave[7].getChips() + ")\n");
        fdbuf.append("Air :\t\t\t\t\t DO192(" + this.airOctave[0].getChips() + ")");
        fdbuf.append(" RE96(" + this.airOctave[1].getChips() + ")");
        fdbuf.append(" MI48(" + this.airOctave[2].getChips() + ")");
        fdbuf.append(" FA24(" + this.airOctave[3].getChips() + ")");
        fdbuf.append(" SO12(" + this.airOctave[4].getChips() + ")");
        fdbuf.append(" LA6(" + this.airOctave[5].getChips() + ")\n");
        fdbuf.append("Impressions :\t\t\t\t\t\t\t  DO48(" + this.impOctave[0].getChips() + ")");
        fdbuf.append(" RE24(" + this.impOctave[1].getChips() + ")");
        fdbuf.append(" MI12(" + this.impOctave[2].getChips() + ")");
        fdbuf.append(" FA6(" + this.impOctave[3].getChips() + ")\n");
        return fdbuf.toString();
    }

    public boolean leaveMI192() {
        return this.foodOctave[2].addChip();
    }

    public boolean leaveMI48() {
        return this.airOctave[2].addChip();
    }

    public boolean leaveDO48() {
        return this.impOctave[0].addChip();
    }

    public void moveAstral() {
        System.out.println("moveAstral (" + this.foodAstral + " " + this.airAstral + " " + this.impAstral + ")");
        int i = 0;
        while (i < this.foodAstral) {
            this.foodOctave[i].setHasAstral(true);
            ++i;
        }
        i = 0;
        while (i < this.airAstral) {
            this.airOctave[i].setHasAstral(true);
            ++i;
        }
        i = 0;
        while (i < this.impAstral) {
            this.impOctave[i].setHasAstral(true);
            ++i;
        }
        this.forceChange();
    }

    public void moveMental() {
        System.out.println("moveMental (" + this.foodMental + " " + this.airMental + " " + this.impMental + ")");
        int i = 0;
        while (i < this.foodMental) {
            this.foodOctave[i].setHasMental(true);
            ++i;
        }
        i = 0;
        while (i < this.airMental) {
            this.airOctave[i].setHasMental(true);
            ++i;
        }
        i = 0;
        while (i < this.impMental) {
            this.impOctave[i].setHasMental(true);
            ++i;
        }
        this.hasMovedMental = true;
        this.forceChange();
    }

    public void moveNextHighestToTI12() {
        int tichips = 1;
        if (this.foodOctave[5].hasChip()) {
            this.foodOctave[5].clearChips();
        } else if (this.foodOctave[4].hasChip()) {
            this.foodOctave[4].clearChips();
        } else if (this.foodOctave[3].hasChip()) {
            this.foodOctave[3].clearChips();
        } else if (this.foodOctave[2].hasChip()) {
            tichips = this.foodOctave[2].getChips();
            this.foodOctave[2].clearChips();
        } else if (this.foodOctave[1].hasChip()) {
            this.foodOctave[1].clearChips();
        } else if (this.foodOctave[0].hasChip()) {
            this.foodOctave[0].clearChips();
        } else {
            tichips = 0;
        }
        this.foodOctave[6].setChips(tichips);
    }

    public boolean hasChrystallizedAstral() {
        return this.hasChrystallizedAstral;
    }

    public boolean hasChrystallizedMental() {
        return this.hasChrystallizedMental;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void checkComplete() {
        if (!this.isComplete) {
            if (this.player.isDead()) {
                this.setComplete(this.hasChrystallizedMental && this.hasMovedMental && this.allNotesHaveChips());
            } else {
                this.setComplete(this.foodMental == 8 && this.airMental == 6 && this.impMental == 4);
            }
        } else if (this.player.isDead()) {
            this.setComplete(this.hasChrystallizedMental && this.hasMovedMental && this.allNotesHaveChips());
        }
    }

    public void setComplete(boolean complete) {
        boolean prevVal = this.isComplete;
        this.isComplete = complete;
        if (this.isComplete) {
            this.changes.firePropertyChange("FoodDiagComplete", prevVal, this.isComplete);
        }
    }

    private boolean allNotesHaveChips() {
        boolean allFull = true;
        int i = 0;
        while (i < this.foodOctave.length) {
            if (!this.foodOctave[i].hasChip()) {
                allFull = false;
            }
            ++i;
        }
        i = 0;
        while (i < this.airOctave.length) {
            if (!this.airOctave[i].hasChip()) {
                allFull = false;
            }
            ++i;
        }
        i = 0;
        while (i < this.impOctave.length) {
            if (!this.impOctave[i].hasChip()) {
                allFull = false;
            }
            ++i;
        }
        return allFull;
    }

    public Object[] getFoodNotes() {
        ArrayList<Object> flist = new ArrayList<Object>(8);
        int i = 0;
        while (i < this.foodOctave.length) {
            if (this.foodOctave[i].hasChip()) {
                flist.add(FoodNotes[i]);
            }
            ++i;
        }
        Object[] foods = flist.size() == 0 ? new Object[]{"(none)"} : flist.toArray();
        return foods;
    }

    public Object[] getAirNotes() {
        ArrayList<Object> alist = new ArrayList<Object>(6);
        int i = 0;
        while (i < this.airOctave.length) {
            if (this.airOctave[i].hasChip()) {
                alist.add(AirNotes[i]);
            }
            ++i;
        }
        Object[] airs = alist.size() == 0 ? new Object[]{"(none)"} : alist.toArray();
        return airs;
    }

    public Object[] getImpNotes() {
        ArrayList<Object> ilist = new ArrayList<Object>(4);
        int i = 0;
        while (i < this.impOctave.length) {
            if (this.impOctave[i].hasChip()) {
                ilist.add(ImpNotes[i]);
            }
            ++i;
        }
        Object[] imps = ilist.size() == 0 ? new Object[]{"(none)"} : ilist.toArray();
        return imps;
    }

    public void transformAll12() {
        short[] sArray = new short[8];
        sArray[7] = (short)this.foodOctave[6].getChips();
        short[] f = sArray;
        short[] sArray2 = new short[4];
        sArray2[3] = (short)this.impOctave[2].getChips();
        short[] i = sArray2;
        this.foodOctave[6].clearChips();
        this.impOctave[2].clearChips();
        this.enterChips(f, null, i);
    }

    public void shockAllMI48() {
        short mi48 = (short)this.airOctave[2].getChips();
        if (mi48 > 0) {
            this.airOctave[2].clearChips();
            short[] sArray = new short[6];
            sArray[5] = mi48;
            this.enterChips(null, sArray, null);
        } else {
            this.airOctave[2].addChip();
        }
    }

    public void moveMI192toTI12() {
        short mi192 = (short)this.foodOctave[2].getChips();
        if (mi192 > 0) {
            this.foodOctave[2].clearChips();
            short[] sArray = new short[8];
            sArray[6] = mi192;
            this.enterChips(sArray, null, null);
        } else {
            this.foodOctave[2].addChip();
        }
    }

    public boolean hasChip(int octave, int i) {
        if (octave == 1) {
            return this.foodOctave[i].hasChip();
        }
        if (octave == 2) {
            return this.airOctave[i].hasChip();
        }
        if (octave == 3) {
            return this.impOctave[i].hasChip();
        }
        return false;
    }

    protected Player getPlayer() {
        return this.player;
    }

    public void forceChange() {
        this.changes.firePropertyChange("FDChange", null, this);
    }

    public void updateState() {
        if (!this.player.isDead()) {
            int i;
            if (this.hasChrystallizedAstral) {
                i = 0;
                while (i < this.foodAstral) {
                    this.foodOctave[i].setHasAstral(true);
                    ++i;
                }
                i = 0;
                while (i < this.airAstral) {
                    this.airOctave[i].setHasAstral(true);
                    ++i;
                }
                i = 0;
                while (i < this.impAstral) {
                    this.impOctave[i].setHasAstral(true);
                    ++i;
                }
            }
            if (this.hasChrystallizedMental) {
                i = 0;
                while (i < this.foodMental) {
                    this.foodOctave[i].setHasMental(true);
                    ++i;
                }
                i = 0;
                while (i < this.airMental) {
                    this.airOctave[i].setHasMental(true);
                    ++i;
                }
                i = 0;
                while (i < this.impMental) {
                    this.impOctave[i].setHasMental(true);
                    ++i;
                }
            }
        }
    }

    public void discardAstral() {
        System.out.println("discardAstral, dead=" + this.player.isDead() + " mental: food=" + this.foodMental + " air=" + this.airMental + " imp=" + this.impMental);
        int i = 0;
        while (i < this.foodOctave.length) {
            this.foodOctave[i].setChips(0);
            ++i;
        }
        i = 0;
        while (i < this.airOctave.length) {
            this.airOctave[i].setChips(0);
            ++i;
        }
        i = 0;
        while (i < this.impOctave.length) {
            this.impOctave[i].setChips(0);
            ++i;
        }
        i = 0;
        while (i < this.foodMental) {
            this.foodOctave[i].setChips(1);
            ++i;
        }
        i = 0;
        while (i < this.airMental) {
            this.airOctave[i].setChips(1);
            ++i;
        }
        i = 0;
        while (i < this.impMental) {
            this.impOctave[i].setChips(1);
            ++i;
        }
        this.hasMovedMental = true;
        this.currentBody = 4;
    }

    private class Note {
        private int maxChips;
        private int chips;
        private boolean hasAstral;
        private boolean hasMental;

        private Note(int max) {
            this.maxChips = max;
        }

        private int getChips() {
            return this.chips;
        }

        private boolean hasChip() {
            return this.chips > 0;
        }

        private boolean hasAstral() {
            return this.hasAstral;
        }

        private boolean hasMental() {
            return this.hasMental;
        }

        private void setChips(int i) {
            this.chips = i;
        }

        private boolean addChip() {
            if (!this.isFull()) {
                ++this.chips;
                return true;
            }
            return false;
        }

        private boolean takeChip() {
            if (this.chips > 0) {
                --this.chips;
                return true;
            }
            return false;
        }

        private void clearChips() {
            this.chips = 0;
        }

        private void setHasAstral(boolean b) {
            this.hasAstral = b;
        }

        private void setHasMental(boolean b) {
            this.hasMental = b;
        }

        private boolean isFull() {
            return this.chips == this.maxChips;
        }

        private byte getState() {
            byte state = 0;
            if (this.hasChip()) {
                state = (byte)(state + 1);
            }
            if (this.hasAstral()) {
                state = (byte)(state + 2);
            }
            if (this.hasMental()) {
                state = (byte)(state + 4);
            }
            return state;
        }
    }
}

