/*
 * Decompiled with CFR 0.152.
 */
package cbg.player;

import cbg.boardParts.Card;
import cbg.common.InvalidCardPlayException;
import cbg.player.LevelOfBeing;
import cbg.player.Multiplicity;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Set;

public class EssenceAndPersonality {
    private HashMap partsOfBeing = new HashMap();
    private boolean foundSchool;
    private boolean gotSteward;
    private boolean gotMaster;
    private boolean gotDouble;
    private boolean gotNothing;
    private boolean isComplete;
    private LevelOfBeing lob;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    public EssenceAndPersonality() {
        short zero = 0;
        PartOfBeing Joker = new PartOfBeing(Card.JO, zero, null);
        PartOfBeing XJoker = new PartOfBeing(Card.XJ, zero, Joker);
        PartOfBeing AceSpades = new PartOfBeing(Card.AS, zero, XJoker);
        PartOfBeing AceHearts = new PartOfBeing(Card.AH, zero, AceSpades);
        PartOfBeing AceClubs = new PartOfBeing(Card.AC, zero, AceHearts);
        PartOfBeing AceDiamonds = new PartOfBeing(Card.AD, zero, AceClubs);
        PartOfBeing KingSpades = new PartOfBeing(Card.KS, zero, AceDiamonds);
        PartOfBeing QueenSpades = new PartOfBeing(Card.QS, zero, KingSpades);
        PartOfBeing JackSpades = new PartOfBeing(Card.JS, zero, QueenSpades);
        PartOfBeing KingHearts = new PartOfBeing(Card.KH, zero, JackSpades);
        PartOfBeing QueenHearts = new PartOfBeing(Card.QH, zero, KingHearts);
        PartOfBeing JackHearts = new PartOfBeing(Card.JH, zero, QueenHearts);
        PartOfBeing KingClubs = new PartOfBeing(Card.KC, zero, JackHearts);
        PartOfBeing QueenClubs = new PartOfBeing(Card.QC, zero, KingClubs);
        PartOfBeing JackClubs = new PartOfBeing(Card.JC, zero, QueenClubs);
        PartOfBeing KingDiamonds = new PartOfBeing(Card.KD, zero, JackClubs);
        PartOfBeing QueenDiamonds = new PartOfBeing(Card.QD, zero, KingDiamonds);
        PartOfBeing JackDiamonds = new PartOfBeing(Card.JD, zero, QueenDiamonds);
        this.partsOfBeing.put(Joker.getCardValue(), Joker);
        this.partsOfBeing.put(XJoker.getCardValue(), XJoker);
        this.partsOfBeing.put(AceSpades.getCardValue(), AceSpades);
        this.partsOfBeing.put(AceHearts.getCardValue(), AceHearts);
        this.partsOfBeing.put(AceClubs.getCardValue(), AceClubs);
        this.partsOfBeing.put(AceDiamonds.getCardValue(), AceDiamonds);
        this.partsOfBeing.put(KingSpades.getCardValue(), KingSpades);
        this.partsOfBeing.put(QueenSpades.getCardValue(), QueenSpades);
        this.partsOfBeing.put(JackSpades.getCardValue(), JackSpades);
        this.partsOfBeing.put(KingHearts.getCardValue(), KingHearts);
        this.partsOfBeing.put(QueenHearts.getCardValue(), QueenHearts);
        this.partsOfBeing.put(JackHearts.getCardValue(), JackHearts);
        this.partsOfBeing.put(KingClubs.getCardValue(), KingClubs);
        this.partsOfBeing.put(QueenClubs.getCardValue(), QueenClubs);
        this.partsOfBeing.put(JackClubs.getCardValue(), JackClubs);
        this.partsOfBeing.put(KingDiamonds.getCardValue(), KingDiamonds);
        this.partsOfBeing.put(QueenDiamonds.getCardValue(), QueenDiamonds);
        this.partsOfBeing.put(JackDiamonds.getCardValue(), JackDiamonds);
        this.gotNothing = false;
        this.gotDouble = false;
        this.gotMaster = false;
        this.gotSteward = false;
        this.foundSchool = false;
        this.lob = new Multiplicity();
    }

    public boolean hasPiece(Card c) {
        return ((PartOfBeing)this.partsOfBeing.get(c)).getChips() > 0;
    }

    public void takePiece(Card c) {
        PartOfBeing taken = (PartOfBeing)this.partsOfBeing.get(c);
        taken.takeChip();
    }

    public short[] createPiece(Card c) {
        short[] shocks = new short[4];
        PartOfBeing newPart = (PartOfBeing)this.partsOfBeing.get(c);
        boolean added = newPart.addChip();
        if (c.getRank() == 11 || c.getRank() == 12 || c.getRank() == 13) {
            shocks[0] = (short)(shocks[0] + 1);
        } else if (c.getRank() == 14) {
            shocks[1] = (short)(shocks[1] + 1);
        } else if (c.getRank() == 15) {
            shocks[2] = (short)(shocks[2] + 1);
        } else if (c.getRank() == 16) {
            shocks[3] = (short)(shocks[3] + 1);
        }
        if (!added) {
            shocks = this.bumpChipsFrom(newPart, shocks);
        }
        this.updateLevelOfBeing();
        return shocks;
    }

    public short[] createTwoPieces(Card c) {
        short[] shocks = new short[4];
        PartOfBeing newPart = (PartOfBeing)this.partsOfBeing.get(c);
        boolean added = newPart.addTwoChips();
        if (c.getRank() == 11 || c.getRank() == 12 || c.getRank() == 13) {
            shocks[0] = (short)(shocks[0] + 1);
        } else if (c.getRank() == 14) {
            shocks[1] = (short)(shocks[1] + 1);
        } else if (c.getRank() == 15) {
            shocks[2] = (short)(shocks[2] + 1);
        } else if (c.getRank() == 16) {
            shocks[3] = (short)(shocks[3] + 1);
        }
        if (!added) {
            newPart.putChip();
            shocks = this.bumpChipsFrom(newPart, shocks);
        }
        this.updateLevelOfBeing();
        return shocks;
    }

    private short[] bumpChipsFrom(PartOfBeing part, short[] shocks) {
        part.takeChip();
        part = part.getNextPart();
        Card c = part.getCardValue();
        if (c.getRank() == 11 || c.getRank() == 12 || c.getRank() == 13) {
            shocks[0] = (short)(shocks[0] + 1);
        } else if (c.getRank() == 14) {
            shocks[1] = (short)(shocks[1] + 1);
        } else if (c.getRank() == 15) {
            shocks[2] = (short)(shocks[2] + 1);
        } else if (c.getRank() == 16) {
            shocks[3] = (short)(shocks[3] + 1);
        }
        if (!part.addChip()) {
            shocks = this.bumpChipsFrom(part, shocks);
        }
        return shocks;
    }

    public short[] createAce(Card card0, Card card1) throws InvalidCardPlayException {
        if (card0.getSuit() != card1.getSuit()) {
            throw new InvalidCardPlayException("Suits must match");
        }
        if (card0.getRank() == card1.getRank()) {
            throw new InvalidCardPlayException("Card rank can not match");
        }
        if (card0.getRank() < 11 || card0.getRank() > 13 || card1.getRank() < 11 || card1.getRank() > 13) {
            throw new InvalidCardPlayException("Rank must be between JACK and KING");
        }
        if (!this.hasPiece(card0)) {
            throw new InvalidCardPlayException("You don't have any " + card0 + " pieces to play");
        }
        if (!this.hasPiece(card1)) {
            throw new InvalidCardPlayException("You don't have any " + card1 + " pieces to play");
        }
        this.takePiece(card0);
        this.takePiece(card1);
        return this.createPiece(new Card(14, card0.getSuit()));
    }

    public short[] createXJ(Card card0, Card card1) throws InvalidCardPlayException {
        if (card0.getRank() != 14 || card1.getRank() != 14) {
            throw new InvalidCardPlayException("You must play two aces to create an extra joker.");
        }
        if (card0.getSuit() == 1 || card1.getSuit() == 1) {
            throw new InvalidCardPlayException("You can't create an extra joker with a spade ace.");
        }
        if (card0.equals(card1)) {
            throw new InvalidCardPlayException("You must play two different aces to create an extra joker.");
        }
        if (!this.hasPiece(card0)) {
            throw new InvalidCardPlayException("You don't have any " + card0 + " pieces to play");
        }
        if (!this.hasPiece(card1)) {
            throw new InvalidCardPlayException("You don't have any " + card1 + " pieces to play");
        }
        this.takePiece(card0);
        this.takePiece(card1);
        return this.createPiece(Card.XJ);
    }

    public void createJoker() throws InvalidCardPlayException {
        if (!this.hasPiece(Card.AS)) {
            throw new InvalidCardPlayException("You do not have an Ace of Spades to make a Joker.");
        }
        if (!this.hasPiece(Card.XJ)) {
            throw new InvalidCardPlayException("You do not have an Extra Joker to make a Joker.");
        }
        this.takePiece(Card.XJ);
        this.takePiece(Card.AS);
        ((PartOfBeing)this.partsOfBeing.get(Card.JO)).addChip();
        this.updateLevelOfBeing();
    }

    public int getChipsFor(Card card) {
        try {
            return ((PartOfBeing)this.partsOfBeing.get(card)).getChips();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("Could not getChipsFor(" + card + ")\t" + " r=" + card.getRank() + "|s=" + card.getSuit());
            return -1;
        }
    }

    public Set getPartsOfBeing() {
        return this.partsOfBeing.keySet();
    }

    public void updateLevelOfBeing() {
        while (this.lob.hasAttainedNewLevelOfBeing(this)) {
            System.out.println("You have attained a new place on the stick!");
            this.setLob(this.lob.increaseLevelOfBeing());
            System.out.println("You are now a " + this.lob.toString());
        }
    }

    public boolean foundSchool() {
        if (this.foundSchool) {
            return this.foundSchool;
        }
        boolean hasJS = this.hasPiece(Card.JS);
        boolean hasQS = this.hasPiece(Card.QS);
        boolean hasKS = this.hasPiece(Card.KS);
        boolean hasJH = this.hasPiece(Card.JH);
        boolean hasQH = this.hasPiece(Card.QH);
        boolean hasKH = this.hasPiece(Card.KH);
        boolean hasJC = this.hasPiece(Card.JC);
        boolean hasQC = this.hasPiece(Card.QC);
        boolean hasKC = this.hasPiece(Card.KC);
        boolean hasJD = this.hasPiece(Card.JD);
        boolean hasQD = this.hasPiece(Card.QD);
        boolean hasKD = this.hasPiece(Card.KD);
        boolean hasAD = this.hasPiece(Card.AD);
        boolean hasAC = this.hasPiece(Card.AC);
        boolean hasAH = this.hasPiece(Card.AH);
        boolean hasAS = this.hasPiece(Card.AS);
        boolean hasXJ = this.hasPiece(Card.XJ);
        boolean hasJO = this.hasPiece(Card.JO);
        if (hasJS && hasQS && hasKS) {
            this.foundSchool = true;
        } else if (hasJH && hasQH && hasKH) {
            this.foundSchool = true;
        } else if (hasJC && hasQC && hasKC) {
            this.foundSchool = true;
        } else if (hasJD && hasQD && hasKD) {
            this.foundSchool = true;
        } else if (hasAD && (hasJD || hasQD || hasKD)) {
            this.foundSchool = true;
        } else if (hasAC && (hasJC || hasQC || hasKD)) {
            this.foundSchool = true;
        } else if (hasAH && (hasJH || hasQH || hasKH)) {
            this.foundSchool = true;
        } else if (hasAS && (hasJS || hasQH || hasKH)) {
            this.foundSchool = true;
        } else if (hasJO) {
            this.foundSchool = true;
        } else {
            int queen_or_king = 0;
            if (hasQD || hasKD) {
                queen_or_king = (short)(queen_or_king + 1);
            }
            if (hasQC || hasKC) {
                queen_or_king = (short)(queen_or_king + 1);
            }
            if (hasQH || hasKH) {
                queen_or_king = (short)(queen_or_king + 1);
            }
            if (hasQS || hasKS) {
                queen_or_king = (short)(queen_or_king + 1);
            }
            if (hasAD) {
                queen_or_king = (short)(queen_or_king + 1);
            }
            if (hasAC) {
                queen_or_king = (short)(queen_or_king + 1);
            }
            if (hasAH) {
                queen_or_king = (short)(queen_or_king + 1);
            }
            if (hasAS) {
                queen_or_king = (short)(queen_or_king + 1);
            }
            if (hasXJ) {
                queen_or_king = (short)(queen_or_king + 2);
            }
            this.foundSchool = queen_or_king >= 3;
        }
        return this.foundSchool;
    }

    public boolean hasAprilFools() {
        if (this.gotSteward) {
            return true;
        }
        boolean hasAS = this.hasPiece(Card.AS);
        boolean hasAH = this.hasPiece(Card.AH);
        boolean hasAC = this.hasPiece(Card.AC);
        boolean hasAD = this.hasPiece(Card.AD);
        boolean hasXJ = this.hasPiece(Card.XJ);
        boolean hasJO = this.hasPiece(Card.JO);
        if (hasAD && hasAC && hasAH && hasAS) {
            this.gotSteward = true;
        } else if (hasXJ && hasAS && (hasAD || hasAC || hasAH)) {
            this.gotSteward = true;
        } else if (hasJO) {
            this.gotSteward = true;
        }
        return this.gotSteward;
    }

    public boolean has1001Words() {
        if (this.hasPiece(Card.JO)) {
            this.gotMaster = true;
        }
        return this.gotMaster;
    }

    public boolean hasDoubled() {
        if (this.gotDouble) {
            return true;
        }
        if (this.getChipsFor(Card.JO) >= 4) {
            this.gotDouble = true;
        }
        return this.gotDouble;
    }

    public boolean hasNothing() {
        if (this.gotNothing) {
            return true;
        }
        if (this.getChipsFor(Card.JO) >= 5) {
            this.gotNothing = true;
        }
        return this.gotNothing;
    }

    public boolean isComplete(boolean isHasnamuss) {
        if (!isHasnamuss) {
            return this.getChipsFor(Card.JO) >= 3;
        }
        return this.cleansedHasnamuss();
    }

    public void setComplete(boolean complete) {
        boolean oldval = this.isComplete;
        this.isComplete = complete;
        this.changes.firePropertyChange("EPComplete", oldval, this.isComplete);
    }

    public LevelOfBeing getLob() {
        return this.lob;
    }

    public void setLob(LevelOfBeing newLevel) {
        LevelOfBeing oldLevel = this.lob;
        this.lob = newLevel;
        this.changes.firePropertyChange("LevelofBeing", oldLevel, newLevel);
    }

    public void clearAllButJoker() {
        PartOfBeing pob = (PartOfBeing)this.partsOfBeing.get(Card.JD);
        while (pob != null) {
            if (pob.getCardValue() != Card.JO) {
                pob.clearChips();
            }
            pob = pob.getNextPart();
        }
    }

    public void removeJoker() {
        this.takePiece(Card.JO);
    }

    public boolean cleansedHasnamuss() {
        return this.getChipsFor(Card.JO) > 3;
    }

    private class PartOfBeing {
        private Card value;
        private short chips;
        private PartOfBeing nextPart;

        private PartOfBeing(Card c, short cnt, PartOfBeing nxt) {
            this.value = c;
            this.chips = cnt;
            this.nextPart = nxt;
        }

        private boolean addChip() {
            if (this.value.getRank() == 16) {
                this.chips = (short)(this.chips + 1);
                return true;
            }
            if (this.chips < 2) {
                this.chips = (short)(this.chips + 1);
                return true;
            }
            return false;
        }

        private boolean addTwoChips() {
            if (this.value.getRank() == 16) {
                this.chips = (short)(this.chips + 2);
                return true;
            }
            if (this.chips == 0) {
                this.chips = (short)(this.chips + 2);
                return true;
            }
            return false;
        }

        private boolean takeChip() {
            if (this.chips <= 0) {
                return false;
            }
            this.chips = (short)(this.chips - 1);
            return true;
        }

        private void clearChips() {
            this.chips = 0;
        }

        private void putChip() {
            this.chips = (short)(this.chips + 1);
        }

        private short getChips() {
            return this.chips;
        }

        private PartOfBeing getNextPart() {
            return this.nextPart;
        }

        private Card getCardValue() {
            return this.value;
        }
    }
}

