/*
 * Decompiled with CFR 0.152.
 */
package cbg.boardParts;

import java.awt.Color;
import java.util.Random;

public class Dice {
    private static Random rand;
    private static int numSides;
    private static int currentRoll;
    private static boolean hasZero;
    private static Color color;
    private static Dice instance;

    private Dice() {
        rand = new Random(System.currentTimeMillis());
        hasZero = true;
        numSides = 10;
        color = Color.red;
    }

    public static Dice getInstance() {
        if (instance == null) {
            instance = new Dice();
        }
        return instance;
    }

    public static void init() {
        rand = new Random(System.currentTimeMillis());
        hasZero = true;
        numSides = 10;
        color = Color.red;
    }

    public static void init(int s) {
        rand = new Random(System.currentTimeMillis());
        hasZero = true;
        numSides = s;
    }

    public static int getNumSides() {
        return numSides;
    }

    public static void setNumSides(int i) {
        numSides = i;
    }

    public static boolean hasZero() {
        return hasZero;
    }

    public static void setHasZero(boolean b) {
        hasZero = b;
    }

    public static int roll() {
        currentRoll = hasZero ? rand.nextInt(numSides) : rand.nextInt(numSides) + 1;
        return currentRoll;
    }

    public static Color getColor() {
        return color;
    }

    public static void setColor(Color color) {
        Dice.color = color;
    }

    public static int getRoll() {
        return currentRoll;
    }

    public static int getOpposite() {
        int maxRoll = numSides;
        if (hasZero) {
            --maxRoll;
        }
        return maxRoll - currentRoll;
    }
}

