/*
 * Decompiled with CFR 0.152.
 */
package cbg.boardParts;

public class Card
implements Comparable {
    public static final Card JS = new Card(11, 1);
    public static final Card QS = new Card(12, 1);
    public static final Card KS = new Card(13, 1);
    public static final Card JH = new Card(11, 2);
    public static final Card QH = new Card(12, 2);
    public static final Card KH = new Card(13, 2);
    public static final Card JC = new Card(11, 3);
    public static final Card QC = new Card(12, 3);
    public static final Card KC = new Card(13, 3);
    public static final Card JD = new Card(11, 4);
    public static final Card QD = new Card(12, 4);
    public static final Card KD = new Card(13, 4);
    public static final Card AS = new Card(14, 1);
    public static final Card AH = new Card(14, 2);
    public static final Card AC = new Card(14, 3);
    public static final Card AD = new Card(14, 4);
    public static final Card XJ = new Card(15, 0);
    public static final Card JO = new Card(16, 0);
    public static final int JACK = 11;
    public static final int QUEEN = 12;
    public static final int KING = 13;
    public static final int ACE = 14;
    public static final int X_J = 15;
    public static final int JOKR = 16;
    public static final int JOKERS = 0;
    public static final int SPADES = 1;
    public static final int HEARTS = 2;
    public static final int CLUBS = 3;
    public static final int DIAMONDS = 4;
    protected int rank;
    protected int suit;

    public Card(int r, int s) {
        this.rank = r;
        this.suit = s;
    }

    public int getRank() {
        return this.rank;
    }

    public int getSuit() {
        return this.suit;
    }

    public void setRank(int i) {
        this.rank = i;
    }

    public void setSuit(int i) {
        this.suit = i;
    }

    public boolean isFaceCard() {
        return this.rank > 10;
    }

    public String toString() {
        String cardVal;
        switch (this.rank) {
            case 2: {
                cardVal = "2";
                break;
            }
            case 3: {
                cardVal = "3";
                break;
            }
            case 4: {
                cardVal = "4";
                break;
            }
            case 5: {
                cardVal = "5";
                break;
            }
            case 6: {
                cardVal = "6";
                break;
            }
            case 7: {
                cardVal = "7";
                break;
            }
            case 8: {
                cardVal = "8";
                break;
            }
            case 9: {
                cardVal = "9";
                break;
            }
            case 10: {
                cardVal = "10";
                break;
            }
            case 11: {
                cardVal = "Jack";
                break;
            }
            case 12: {
                cardVal = "Queen";
                break;
            }
            case 13: {
                cardVal = "King";
                break;
            }
            case 14: {
                cardVal = "Ace";
                break;
            }
            case 15: {
                return "EXTRA JOKER";
            }
            case 16: {
                return "JOKER";
            }
            default: {
                return "NotACard";
            }
        }
        cardVal = String.valueOf(cardVal) + " of";
        switch (this.suit) {
            case 1: {
                cardVal = String.valueOf(cardVal) + " Spades";
                return cardVal;
            }
            case 2: {
                cardVal = String.valueOf(cardVal) + " Hearts";
                return cardVal;
            }
            case 3: {
                cardVal = String.valueOf(cardVal) + " Clubs";
                return cardVal;
            }
            case 4: {
                cardVal = String.valueOf(cardVal) + " Diamonds";
                return cardVal;
            }
        }
        return "NotACard";
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            return ((Card)o).suit == this.suit && ((Card)o).rank == this.rank;
        }
        return false;
    }

    public int hashCode() {
        return this.rank * 10 + this.suit;
    }

    public int compareTo(Object o) {
        Card aCard = (Card)o;
        boolean EQUAL = false;
        boolean GREATER = true;
        int LESS = -1;
        if (this == aCard) {
            return 0;
        }
        if (this.suit > aCard.suit) {
            return 1;
        }
        if (this.suit < aCard.suit) {
            return -1;
        }
        if (this.rank < aCard.rank) {
            return -1;
        }
        if (this.rank > aCard.rank) {
            return 1;
        }
        if (!this.equals(aCard)) {
            System.err.println("compareTo inconsistent with equals: !" + this.toString() + ".equals(" + aCard + ")");
        }
        return 0;
    }

    public static Card playsWith(Card aCard, Card bCard) {
        if (aCard.equals(bCard)) {
            return null;
        }
        if (aCard.suit != bCard.suit) {
            return null;
        }
        if (aCard.isFaceCard() || bCard.isFaceCard()) {
            return null;
        }
        if (aCard.rank < 5 && bCard.rank < 5) {
            return new Card(11, aCard.suit);
        }
        if (aCard.rank > 7 && bCard.rank > 7) {
            return new Card(13, aCard.suit);
        }
        if (aCard.rank >= 5 && aCard.rank <= 7 && bCard.rank >= 5 && bCard.rank <= 7) {
            return new Card(12, aCard.suit);
        }
        return null;
    }

    public static Card playTrips(Card c1, Card c2, Card c3) {
        if (c1.equals(c2) || c1.equals(c3) || c2.equals(c3)) {
            return null;
        }
        if (c1.suit != c2.suit || c1.suit != c3.suit) {
            return null;
        }
        if (c1.isFaceCard() || c2.isFaceCard() || c3.isFaceCard()) {
            return null;
        }
        if (c1.rank < 5 && c2.rank < 5 && c3.rank < 5) {
            return new Card(11, c1.suit);
        }
        if (c1.rank > 7 && c2.rank > 7 && c3.rank > 7) {
            return new Card(13, c1.suit);
        }
        if (c1.rank >= 5 && c1.rank <= 7 && c2.rank >= 5 && c2.rank <= 7 && c3.rank >= 5 && c3.rank <= 7) {
            return new Card(12, c1.suit);
        }
        return null;
    }
}

