/*
 * Decompiled with CFR 0.152.
 */
package cbg.boardParts;

import cbg.boardParts.AirSpace;
import cbg.boardParts.BoardSpace;
import cbg.boardParts.CardSpace;
import cbg.boardParts.DecaySpace;
import cbg.boardParts.FoodSpace;
import cbg.boardParts.ImpSpace;
import cbg.boardParts.LawSpace;
import cbg.boardParts.WildSpace;

public class Board {
    private static BoardSpace[] board;
    private static final String spaces = "*AFAIFCACFFCIAACFFICAFACCFICFAAFCCLAFICCFAFICAFCCIAACFFICAICAFFICCAAIFCLLCFFIAAICCFIACIFACIAFICAILFCAACICCFAICFFACICAIFCCFICACFALLCCFACCCFICFCAICCIAFFICAALCCIFACCCIFICAACCICFFCCIAFCCALLCCCAFFACIAFCCIACFACILCAFFCCAIAFCCIACFFICCCAICCFCALLCCAAFCIC*";

    private Board() {
        Board.init();
    }

    public static void init() {
        board = new BoardSpace[spaces.length()];
        int i = 0;
        while (i < spaces.length()) {
            switch (spaces.charAt(i)) {
                case 'F': {
                    Board.board[i] = new FoodSpace();
                    break;
                }
                case 'A': {
                    Board.board[i] = new AirSpace();
                    break;
                }
                case 'I': {
                    Board.board[i] = new ImpSpace();
                    break;
                }
                case 'L': {
                    Board.board[i] = new LawSpace();
                    break;
                }
                case 'C': {
                    Board.board[i] = new CardSpace();
                    break;
                }
                case '*': {
                    Board.board[i] = new WildSpace();
                }
            }
            ++i;
        }
    }

    public static void initDeathBoard() {
        System.out.println("Making the afterlife board.");
        int i = 0;
        while (i < board.length) {
            switch (board[i].toString().charAt(1)) {
                case 'L': {
                    Board.board[i] = new WildSpace();
                    break;
                }
                case 'C': {
                    Board.board[i] = new DecaySpace();
                }
            }
            ++i;
        }
    }

    public static void reverseBoard() {
        int left = 0;
        int right = board.length - 1;
        while (left < right) {
            BoardSpace temp = board[left];
            Board.board[left] = board[right];
            Board.board[right] = temp;
            ++left;
            --right;
        }
    }

    public static BoardSpace getSpace(int i) {
        if (i >= spaces.length()) {
            i = spaces.length() - 1;
        }
        return board[i];
    }

    public static int getNumSpaces() {
        return spaces.length();
    }

    public static String nextTen(int pos) {
        String nextten = "";
        int maxpos = 10;
        if (Board.getNumSpaces() <= pos + maxpos) {
            maxpos = Board.getNumSpaces() - pos;
        }
        int i = 0;
        while (i < maxpos) {
            nextten = String.valueOf(nextten) + board[pos + i];
            ++i;
        }
        return nextten;
    }

    public static String next30(int pos) {
        int maxpos = 30;
        if (Board.getNumSpaces() <= pos + maxpos) {
            return spaces.substring(pos);
        }
        return spaces.substring(pos, maxpos);
    }

    public static void printBoard() {
        System.out.print("Board=");
        int i = 0;
        while (i < spaces.length()) {
            System.out.print(board[i]);
            ++i;
        }
        System.out.println();
    }

    public static int getSpaceCharAt(int spaceNum) {
        return spaces.charAt(spaceNum);
    }
}

